/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import java.util.ArrayList;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Quad;

public class FlatLine2d
extends AbstractComposite {
    public FlatLine2d() {
    }

    public FlatLine2d(float[] x, float[] y, float depth) {
        this.setData(x, y, depth);
    }

    public void setData(float[] x, float[] y, float depth) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must have equal length");
        }
        ArrayList<AbstractDrawable> quads = new ArrayList<AbstractDrawable>(x.length * y.length);
        for (int i = 0; i < x.length - 1; ++i) {
            quads.add(this.getLineElement(x[i], x[i + 1], y[i], y[i + 1], depth));
        }
        this.add(quads);
    }

    protected AbstractDrawable getLineElement(float x1, float x2, float y1, float y2, float depth) {
        Quad q = new Quad();
        q.add(new Point(new Coord3d(0.0f, x1, y1)));
        q.add(new Point(new Coord3d(0.0f, x2, y2)));
        q.add(new Point(new Coord3d(depth, x2, y2)));
        q.add(new Point(new Coord3d(depth, x1, y1)));
        return q;
    }
}

