/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.transform.Transform;

public class ConcurrentLineStrip
extends LineStrip {
    public ConcurrentLineStrip() {
        super(100);
    }

    public ConcurrentLineStrip(int n) {
        super(n);
    }

    public ConcurrentLineStrip(List<Coord3d> coords) {
        super(coords);
    }

    public ConcurrentLineStrip(Point c1, Point c2) {
        super(c1, c2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawLine(GL gl) {
        gl.glLineWidth(this.width);
        if (gl.isGL2()) {
            List list = this.points;
            synchronized (list) {
                this.drawLineGL2(gl);
            }
        }
        List list = this.points;
        synchronized (list) {
            this.drawLineGLES2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawPoints(GL gl) {
        if (this.showPoints) {
            if (gl.isGL2()) {
                List list = this.points;
                synchronized (list) {
                    this.drawPointsGL2(gl);
                }
            }
            List list = this.points;
            synchronized (list) {
                this.drawPointsGLES2();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyGeometryTransform(Transform transform) {
        List list = this.points;
        synchronized (list) {
            for (Point p : this.points) {
                p.xyz = transform.compute(p.xyz);
            }
        }
        this.updateBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBounds() {
        this.bbox.reset();
        List list = this.points;
        synchronized (list) {
            for (Point p : this.points) {
                this.bbox.add(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Point point) {
        List list = this.points;
        synchronized (list) {
            this.points.add(point);
        }
        this.bbox.add(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List list = this.points;
        synchronized (list) {
            this.points.clear();
        }
        this.updateBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLastPoint() {
        List list = this.points;
        synchronized (list) {
            return super.getLastPoint();
        }
    }
}

