/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.events.IDrawableListener;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.IGLRenderer;
import org.jzy3d.plot3d.primitives.ISortableDraw;
import org.jzy3d.plot3d.primitives.Parallelepiped;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.legends.ILegend;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public abstract class AbstractDrawable
implements IGLRenderer,
ISortableDraw {
    protected Transform transform;
    protected Transform transformBefore;
    protected BoundingBox3d bbox;
    protected ILegend legend = null;
    protected List<IDrawableListener> listeners;
    protected boolean hasListeners = true;
    protected boolean displayed = true;
    protected boolean legendDisplayed = false;
    protected boolean boundingBoxDisplayed = false;
    protected Color boundingBoxColor = Color.BLACK.clone();
    protected SpaceTransformer spaceTransformer = null;

    public void dispose() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    @Override
    public abstract void draw(GL var1, GLU var2, Camera var3);

    public abstract void applyGeometryTransform(Transform var1);

    public abstract void updateBounds();

    public void doTransform(GL gl, GLU glu, Camera cam) {
        if (this.transformBefore != null) {
            if (this.transformBefore != null) {
                this.transformBefore.execute(gl, true);
            }
            if (this.transform != null) {
                this.transform.execute(gl, false);
            }
        } else if (this.transform != null) {
            this.transform.execute(gl);
        }
    }

    protected void doDrawBounds(GL gl, GLU glu, Camera cam) {
        if (this.isBoundingBoxDisplayed()) {
            Parallelepiped p = new Parallelepiped(this.getBounds());
            p.setFaceDisplayed(false);
            p.setWireframeColor(this.getBoundingBoxColor());
            p.draw(gl, glu, cam);
        }
    }

    protected void vertexGL2(GL gl, Coord3d c) {
        if (this.spaceTransformer == null) {
            gl.getGL2().glVertex3f(c.x, c.y, c.z);
        } else {
            gl.getGL2().glVertex3f(this.spaceTransformer.getX().compute(c.x), this.spaceTransformer.getY().compute(c.y), this.spaceTransformer.getZ().compute(c.z));
        }
    }

    protected void vertexGLES2(Coord3d c) {
        if (this.spaceTransformer == null) {
            GLES2CompatUtils.glVertex3f(c.x, c.y, c.z);
        } else {
            GLES2CompatUtils.glVertex3f(this.spaceTransformer.getX().compute(c.x), this.spaceTransformer.getY().compute(c.y), this.spaceTransformer.getZ().compute(c.z));
        }
    }

    protected void colorGL2(GL gl, Color c) {
        gl.getGL2().glColor4f(c.r, c.g, c.b, c.a);
    }

    protected void colorGLES2(Color c) {
        GLES2CompatUtils.glColor4f(c.r, c.g, c.b, c.a);
    }

    protected void call(GL gl, Color c) {
        if (gl.isGL2()) {
            this.colorGL2(gl, c);
        } else {
            this.colorGLES2(c);
        }
    }

    protected void call(GL gl, Color c, float alpha) {
        if (gl.isGL2()) {
            gl.getGL2().glColor4f(c.r, c.g, c.b, alpha);
        } else {
            GLES2CompatUtils.glColor4f(c.r, c.g, c.b, alpha);
        }
    }

    protected void callWithAlphaFactor(GL gl, Color c, float alpha) {
        if (gl.isGL2()) {
            gl.getGL2().glColor4f(c.r, c.g, c.b, c.a * alpha);
        } else {
            GLES2CompatUtils.glColor4f(c.r, c.g, c.b, c.a * alpha);
        }
    }

    protected void negative(Color c) {
        c.r = 1.0f - c.r;
        c.g = 1.0f - c.g;
        c.b = 1.0f - c.b;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
        this.fireDrawableChanged(1);
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Transform getTransformBefore() {
        return this.transformBefore;
    }

    public void setTransformBefore(Transform transformBefore) {
        this.transformBefore = transformBefore;
    }

    public BoundingBox3d getBounds() {
        return this.bbox;
    }

    public Coord3d getBarycentre() {
        if (this.bbox != null) {
            return this.bbox.getCenter();
        }
        return Coord3d.INVALID.clone();
    }

    public void setDisplayed(boolean status) {
        this.displayed = status;
        this.fireDrawableChanged(4);
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    @Override
    public double getDistance(Camera camera) {
        return this.getBarycentre().distance(camera.getEye());
    }

    @Override
    public double getShortestDistance(Camera camera) {
        return this.getDistance(camera);
    }

    @Override
    public double getLongestDistance(Camera camera) {
        return this.getDistance(camera);
    }

    public void setLegend(ILegend face) {
        this.legend = face;
        this.legendDisplayed = true;
        this.fireDrawableChanged(3);
    }

    public ILegend getLegend() {
        return this.legend;
    }

    public boolean hasLegend() {
        return this.legend != null;
    }

    public void setLegendDisplayed(boolean status) {
        this.legendDisplayed = status;
    }

    public boolean isLegendDisplayed() {
        return this.legendDisplayed;
    }

    public boolean isBoundingBoxDisplayed() {
        return this.boundingBoxDisplayed;
    }

    public void setBoundingBoxDisplayed(boolean boundingBoxDisplayed) {
        this.boundingBoxDisplayed = boundingBoxDisplayed;
    }

    public Color getBoundingBoxColor() {
        return this.boundingBoxColor;
    }

    public void setBoundingBoxColor(Color boundingBoxColor) {
        this.boundingBoxColor = boundingBoxColor;
    }

    public SpaceTransformer getSpaceTransformer() {
        return this.spaceTransformer;
    }

    public void setSpaceTransformer(SpaceTransformer spaceTransformer) {
        this.spaceTransformer = spaceTransformer;
    }

    public void addDrawableListener(IDrawableListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IDrawableListener>();
        }
        this.listeners.add(listener);
        this.hasListeners = true;
    }

    public void removeDrawableListener(IDrawableListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDrawableChanged(int eventType) {
        if (this.listeners != null) {
            this.fireDrawableChanged(new DrawableChangedEvent(this, eventType));
        }
    }

    protected void fireDrawableChanged(DrawableChangedEvent e) {
        if (this.listeners != null) {
            for (IDrawableListener listener : this.listeners) {
                listener.drawableChanged(e);
            }
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int depth) {
        return Utils.blanks(depth) + "(" + this.getClass().getSimpleName() + ")";
    }
}

