/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.rendering;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jzy3d.plot2d.rendering.Canvas;

public class CanvasAWT
implements Canvas {
    private Graphics2D target;
    private Color bgColor = WHITE;
    private Color fgColor = BLACK;
    private static Color WHITE = Color.WHITE;
    private static Color BLACK = Color.BLACK;
    private static final int PIXEL_WITH = 2;

    public CanvasAWT(Graphics2D graphic) {
        this.target = graphic;
    }

    @Override
    public void drawString(int x, int y, String text) {
        this.target.setColor(this.fgColor);
        this.target.drawString(text, x, y);
    }

    @Override
    public void drawRect(org.jzy3d.colors.Color color, int x, int y, int width, int height, boolean border) {
        if (color != null) {
            this.target.setColor(CanvasAWT.awt(color));
            this.target.fillRect(x, y, width, height);
        }
        if (border) {
            this.target.setColor(BLACK);
            this.target.drawRect(x, y, width, height);
        }
    }

    @Override
    public void drawRect(org.jzy3d.colors.Color color, int x, int y, int width, int height) {
        this.drawRect(color, x, y, width, height, true);
    }

    @Override
    public void drawDot(org.jzy3d.colors.Color color, int x, int y) {
        this.target.setColor(CanvasAWT.awt(color));
        this.target.fillRect(x - 1, y - 1, 2, 2);
    }

    @Override
    public void drawOval(org.jzy3d.colors.Color color, int x, int y, int width, int height) {
        this.target.setColor(CanvasAWT.awt(color));
        this.target.fillOval(x, y, width, height);
        this.target.setColor(BLACK);
        this.target.drawOval(x, y, width, height);
    }

    @Override
    public void drawBackground(org.jzy3d.colors.Color color, int width, int height) {
        this.bgColor = CanvasAWT.awt(color);
        this.target.setColor(this.bgColor);
        this.target.fillRect(0, 0, width, height);
    }

    public static Color awt(org.jzy3d.colors.Color color) {
        return new Color(color.r, color.g, color.b);
    }
}

