/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

public class Scale {
    protected float min;
    protected float max;

    public Scale(float min, float max) {
        this.min = min;
        this.max = max;
    }

    public Scale(double min, double max) {
        this((float)min, (float)max);
    }

    public Scale clone() {
        return new Scale(this.min, this.max);
    }

    public float getMin() {
        return this.min;
    }

    public float getMax() {
        return this.max;
    }

    public float getRange() {
        return this.max - this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public Scale add(float value) {
        return new Scale(this.min + value, this.max + value);
    }

    public boolean contains(float value) {
        return this.min <= value && value <= this.max;
    }

    public boolean isMaxNan() {
        return Double.isNaN(this.max);
    }

    public boolean isMinNan() {
        return Double.isNaN(this.min);
    }

    public boolean isIn(float value) {
        return this.isIn(value, false, true);
    }

    public boolean isIn(float value, boolean includingMin, boolean includingMax) {
        if (includingMin ? value < this.min : value <= this.min) {
            return false;
        }
        return !(includingMax ? value > this.max : value >= this.max);
    }

    public boolean valid() {
        return this.min <= this.max;
    }

    public static Scale widest(Scale scale1, Scale scale2) {
        float min = Math.min(scale1.min, scale2.min);
        float max = Math.max(scale1.max, scale2.max);
        return new Scale(min, max);
    }

    public static Scale thinest(Scale scale1, Scale scale2) {
        float min = Math.max(scale1.min, scale2.min);
        float max = Math.min(scale1.max, scale2.max);
        return new Scale(min, max);
    }

    public static Scale enlarge(Scale input, float ratio) {
        float offset = (input.getMax() - input.getMin()) * ratio;
        if (offset == 0.0f) {
            offset = 1.0f;
        }
        return new Scale(input.getMin() - offset, input.getMax() + offset);
    }

    public void enlargeSelf(double ratio) {
        double offset = (double)(this.max - this.min) * ratio;
        if (offset == 0.0) {
            offset = 1.0;
        }
        this.min = (float)((double)this.min - offset);
        this.max = (float)((double)this.max + offset);
    }

    public String toString() {
        return new String("min=" + this.min + " max=" + this.max);
    }
}

