/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.Point;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Rectangle(Dimension d) {
        this.width = d.getWidth();
        this.height = d.getHeight();
    }

    public Rectangle(Point p) {
        this.x = p.getX();
        this.y = p.getY();
    }

    public Rectangle(Point p, Dimension d) {
        this.x = p.getX();
        this.y = p.getY();
        this.width = d.getWidth();
        this.height = d.getHeight();
    }

    public Rectangle intersection(Rectangle r) {
        int tx1 = this.x;
        int ty1 = this.y;
        int rx1 = r.x;
        int ry1 = r.y;
        long tx2 = tx1;
        tx2 += (long)this.width;
        long ty2 = ty1;
        ty2 += (long)this.height;
        long rx2 = rx1;
        rx2 += (long)r.width;
        long ry2 = ry1;
        ry2 += (long)r.height;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Rectangle(tx1, ty1, (int)tx2, (int)ty2);
    }
}

