/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Range;

public class Coord3d
implements Serializable {
    private static final long serialVersionUID = -1636927109633279805L;
    public static final Coord3d ORIGIN = new Coord3d(0.0f, 0.0f, 0.0f);
    public static final Coord3d IDENTITY = new Coord3d(1.0f, 1.0f, 1.0f);
    public static final Coord3d INVALID = new Coord3d(Float.NaN, Float.NaN, Float.NaN);
    public float x;
    public float y;
    public float z;

    public static List<Coord3d> list(int size) {
        return new ArrayList<Coord3d>(size);
    }

    public static Range getZRange(List<Coord3d> coords) {
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (Coord3d c : coords) {
            if (c.z > max) {
                max = c.z;
            }
            if (!(c.z < min)) continue;
            min = c.z;
        }
        return new Range(min, max);
    }

    public Coord3d() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Coord3d(float xi, float yi, float zi) {
        this.x = xi;
        this.y = yi;
        this.z = zi;
    }

    public Coord3d(Coord2d c, float zi) {
        this.x = c.x;
        this.y = c.y;
        this.z = zi;
    }

    public Coord3d(float[] c) {
        this.x = c[0];
        this.y = c[1];
        this.z = c[2];
    }

    public Coord3d(double xi, double yi, double zi) {
        this.x = (float)xi;
        this.y = (float)yi;
        this.z = (float)zi;
    }

    public Coord3d set(Coord3d c2) {
        this.x = c2.x;
        this.y = c2.y;
        this.z = c2.z;
        return this;
    }

    public Coord3d set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Coord3d clone() {
        return new Coord3d(this.x, this.y, this.z);
    }

    public Coord2d getXY() {
        return new Coord2d(this.x, this.y);
    }

    public Coord3d add(Coord3d c2) {
        return new Coord3d(this.x + c2.x, this.y + c2.y, this.z + c2.z);
    }

    public Coord3d add(float x, float y, float z) {
        return new Coord3d(this.x + x, this.y + y, this.z + z);
    }

    public Coord3d addSelf(Coord3d c2) {
        this.x += c2.x;
        this.y += c2.y;
        this.z += c2.z;
        return this;
    }

    public Coord3d add(float value) {
        return new Coord3d(this.x + value, this.y + value, this.z + value);
    }

    public Coord3d addSelf(float value) {
        this.x += value;
        this.y += value;
        this.z += value;
        return this;
    }

    public Coord3d sub(Coord3d c2) {
        return new Coord3d(this.x - c2.x, this.y - c2.y, this.z - c2.z);
    }

    public Coord3d subSelf(Coord3d c2) {
        this.x -= c2.x;
        this.y -= c2.y;
        this.z -= c2.z;
        return this;
    }

    public Coord3d sub(float value) {
        return new Coord3d(this.x - value, this.y - value, this.z - value);
    }

    public Coord3d subSelf(float value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        return this;
    }

    public Coord3d mul(Coord3d c2) {
        return new Coord3d(this.x * c2.x, this.y * c2.y, this.z * c2.z);
    }

    public void mulSelf(Coord3d c2) {
        this.x *= c2.x;
        this.y *= c2.y;
        this.z *= c2.z;
    }

    public Coord3d mul(float value) {
        return new Coord3d(this.x * value, this.y * value, this.z * value);
    }

    public Coord3d div(Coord3d c2) {
        return new Coord3d(this.x / c2.x, this.y / c2.y, this.z / c2.z);
    }

    public void divSelf(Coord3d c2) {
        this.x /= c2.x;
        this.y /= c2.y;
        this.z /= c2.z;
    }

    public Coord3d div(float value) {
        return new Coord3d(this.x / value, this.y / value, this.z / value);
    }

    public Coord3d negative() {
        return new Coord3d(-this.x, -this.y, -this.z);
    }

    public Coord3d cartesian() {
        return new Coord3d(Math.cos(this.x) * Math.cos(this.y) * (double)this.z, Math.sin(this.x) * Math.cos(this.y) * (double)this.z, Math.sin(this.y) * (double)this.z);
    }

    public Coord3d polar() {
        double r = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        if (d == 0.0 && this.z > 0.0f) {
            return new Coord3d(0.0, 1.5707963267948966, r);
        }
        if (d == 0.0 && this.z <= 0.0f) {
            return new Coord3d(0.0, -1.5707963267948966, r);
        }
        double a = Math.abs((double)this.x / d) < 1.0 ? Math.acos((double)this.x / d) * (double)(this.y > 0.0f ? 1 : -1) : (this.y == 0.0f && this.x > 0.0f ? 0.0 : (this.y == 0.0f && this.x < 0.0f ? Math.PI : 0.0));
        double e = Math.atan((double)this.z / d);
        return new Coord3d(a, e, r);
    }

    public double distance(Coord3d c) {
        return Math.sqrt(this.distanceSq(c));
    }

    public double distanceSq(Coord3d c) {
        return Math.pow(this.x - c.x, 2.0) + Math.pow(this.y - c.y, 2.0) + Math.pow(this.z - c.z, 2.0);
    }

    public float magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Coord3d getNormalizedTo(float len) {
        return this.clone().normalizeTo(len);
    }

    public Coord3d normalizeTo(float len) {
        float mag = (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        if (mag > 0.0f) {
            mag = len / mag;
            this.x *= mag;
            this.y *= mag;
            this.z *= mag;
        }
        return this;
    }

    public final float dot(Coord3d v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public final Coord3d cross(Coord3d v) {
        return new Coord3d(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public final Coord3d rotate(float angleDeg, Coord3d axis) {
        float angleRad = (float)Math.toRadians(angleDeg);
        float s = (float)Math.sin(angleRad);
        float c = (float)Math.cos(angleRad);
        Coord3d v = this;
        Coord3d k = axis.normalizeTo(1.0f);
        float kdotv = k.dot(v);
        Coord3d kXv = k.cross(v);
        return new Coord3d(v.x * c + kXv.x * s + k.x * kdotv * (1.0f - c), v.y * c + kXv.y * s + k.y * kdotv * (1.0f - c), v.z * c + kXv.z * s + k.z * kdotv * (1.0f - c));
    }

    public final Coord3d interpolateTo(Coord3d v, float f) {
        return new Coord3d(this.x + (v.x - this.x) * f, this.y + (v.y - this.y) * f, this.z + (v.z - this.z) * f);
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y + " z=" + this.z;
    }

    public float[] toArray() {
        float[] array = new float[]{this.x, this.y, this.z};
        return array;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coord3d)) {
            return false;
        }
        Coord3d other = (Coord3d)obj;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }
}

