/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io;

import au.com.bytecode.opencsv.CSVReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord3d;

public class FileDataset {
    public static Coord3d[] loadArray(String filename) throws IOException {
        String[] nextLine;
        int size = FileDataset.readNLines(filename);
        Coord3d[] coords = new Coord3d[size];
        CSVReader reader = new CSVReader((Reader)new FileReader(filename));
        int k = 0;
        while ((nextLine = reader.readNext()) != null) {
            if (nextLine.length < 3) continue;
            float x = Float.parseFloat(nextLine[0]);
            float y = Float.parseFloat(nextLine[1]);
            float z = Float.parseFloat(nextLine[2]);
            coords[k++] = new Coord3d(x, y, z);
        }
        reader.close();
        return coords;
    }

    public static List<Coord3d> loadList(String filename) throws IOException {
        String[] nextLine;
        ArrayList<Coord3d> coords = new ArrayList<Coord3d>();
        CSVReader reader = new CSVReader((Reader)new FileReader(filename));
        while ((nextLine = reader.readNext()) != null) {
            if (nextLine.length < 3) continue;
            float x = Float.parseFloat(nextLine[0]);
            float y = Float.parseFloat(nextLine[1]);
            float z = Float.parseFloat(nextLine[2]);
            coords.add(new Coord3d(x, y, z));
        }
        reader.close();
        return coords;
    }

    protected static int readNLines(String filename) throws IOException {
        CSVReader reader = new CSVReader((Reader)new FileReader(filename));
        int n = 0;
        while (reader.readNext() != null) {
            ++n;
        }
        reader.close();
        return n;
    }

    public static Coord3d[] toArray(List<Coord3d> list) {
        Coord3d[] points = new Coord3d[list.size()];
        int k = 0;
        for (Coord3d c : list) {
            points[k++] = c;
        }
        return points;
    }
}

