/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.demos.surface;

import org.jzy3d.analysis.AbstractAnalysis;
import org.jzy3d.analysis.AnalysisLauncher;
import org.jzy3d.chart.factories.AWTChartComponentFactory;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Builder;
import org.jzy3d.plot3d.builder.Mapper;
import org.jzy3d.plot3d.builder.concrete.OrthonormalGrid;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.rendering.canvas.Quality;

public class SurfaceDemo
extends AbstractAnalysis {
    public static void main(String[] args) throws Exception {
        AnalysisLauncher.open(new SurfaceDemo());
    }

    @Override
    public void init() {
        Mapper mapper = new Mapper(){

            @Override
            public double f(double x, double y) {
                return x * Math.sin(x * y);
            }
        };
        Range range = new Range(-3.0f, 3.0f);
        int steps = 80;
        Shape surface = Builder.buildOrthonormal(new OrthonormalGrid(range, steps, range, steps), mapper);
        surface.setColorMapper(new ColorMapper(new ColorMapRainbow(), surface.getBounds().getZmin(), surface.getBounds().getZmax(), new Color(1.0f, 1.0f, 1.0f, 0.5f)));
        surface.setFaceDisplayed(true);
        surface.setWireframeDisplayed(false);
        this.chart = AWTChartComponentFactory.chart(Quality.Advanced, this.getCanvasType());
        this.chart.getScene().getGraph().add(surface);
    }
}

