/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.demos.drawing.vbo.barmodel.builder;

import com.jogamp.opengl.GL;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.vbo.buffers.FloatVBO;
import org.jzy3d.plot3d.primitives.vbo.builders.VBOBuilder;
import org.jzy3d.plot3d.primitives.vbo.drawable.DrawableVBO;
import org.jzy3d.plot3d.rendering.canvas.Quality;

public class VBOBuilderLineStrip
extends VBOBuilder {
    List<Float> values;
    boolean colorPerVertex = true;

    public VBOBuilderLineStrip(List<Float> values) {
        this.values = values;
    }

    @Override
    public void load(GL gl, DrawableVBO drawable) throws Exception {
        this.preConfigureDrawable(drawable);
        FloatVBO vbo = this.initFloatVBO(drawable, this.colorPerVertex, this.values.size() / 2);
        this.fill(this.values, vbo);
        drawable.setData(gl, vbo);
    }

    private void preConfigureDrawable(DrawableVBO drawable) {
        drawable.setGeometry(3);
        drawable.setHasColorBuffer(this.colorPerVertex);
        drawable.setWidth(5.0f);
        drawable.setQuality(Quality.Nicest);
    }

    private void fill(List<Float> values2, FloatVBO vbo) {
        int k = 0;
        for (Float f : values2) {
            Coord3d c = new Coord3d((double)k, (double)f.floatValue(), Math.random());
            Color col = Color.RED;
            this.putPoint(vbo, k, col, c);
            ++k;
        }
        vbo.getVertices().rewind();
        vbo.getIndices().rewind();
    }
}

