/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.contour;

import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorAWT;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.contour.AbstractContourGenerator;
import org.jzy3d.contour.IContourColoringPolicy;
import org.jzy3d.maths.Coord3d;

public class DefaultContourColoringPolicy
implements IContourColoringPolicy {
    protected ColorMapper cmapper;
    protected static int WHITE_ALPHA_RGB = ColorAWT.toAWT(Color.WHITE).getRGB();

    public DefaultContourColoringPolicy(ColorMapper cmapper) {
        this.cmapper = cmapper;
    }

    @Override
    public int getRGB(double z) {
        if (z != AbstractContourGenerator.NON_CONTOUR) {
            Coord3d coord = new Coord3d(0.0, 0.0, z);
            Color color = this.cmapper.getColor(coord);
            return ColorAWT.toAWT(color).getRGB();
        }
        return WHITE_ALPHA_RGB;
    }

    public ColorMapper getColorMapper() {
        return this.cmapper;
    }

    public void setColorMmapper(ColorMapper cmapper) {
        this.cmapper = cmapper;
    }
}

