/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart2d;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public class AxeBox2d
extends AxeBox {
    protected RotatedTextBitmapRenderer txtRotation = new RotatedTextBitmapRenderer();

    public AxeBox2d(BoundingBox3d bbox, IAxeLayout layout) {
        super(bbox, layout);
    }

    public AxeBox2d(BoundingBox3d bbox) {
        super(bbox);
        this.txt = new TextBitmapRenderer();
    }

    @Override
    public void drawTicksAndLabels(GL gl, GLU glu, Camera camera) {
        this.wholeBounds.reset();
        this.wholeBounds.add(this.boxBounds);
        this.drawTicksAndLabelsX(gl, glu, camera);
        this.drawTicksAndLabelsY(gl, glu, camera);
    }

    @Override
    protected int findClosestXaxe(Camera cam) {
        return 0;
    }

    @Override
    protected int findClosestYaxe(Camera cam) {
        return 3;
    }

    @Override
    public Halign layoutHorizontal(int direction, Camera cam, Halign hal, Coord3d tickPosition) {
        if (direction == 0) {
            return Halign.CENTER;
        }
        if (direction == 1) {
            return Halign.LEFT;
        }
        return Halign.LEFT;
    }

    @Override
    public void drawAxisLabel(GL gl, GLU glu, Camera cam, int direction, Color color, BoundingBox3d ticksTxtBounds, double xlab, double ylab, double zlab, String axeLabel) {
        Coord3d labelPosition = new Coord3d(xlab, ylab, zlab);
        BoundingBox3d labelBounds = null;
        if (this.isXDisplayed(direction)) {
            labelBounds = this.txt.drawText(gl, glu, cam, axeLabel, labelPosition, Halign.CENTER, Valign.CENTER, color, 1);
        } else if (this.isYDisplayed(direction)) {
            labelBounds = this.txt.drawText(gl, glu, cam, axeLabel, labelPosition, Halign.CENTER, Valign.CENTER, color, 1);
        }
        if (labelBounds != null) {
            ticksTxtBounds.add(labelBounds);
        }
        this.doTransform(gl);
    }

    public class RotatedTextBitmapRenderer
    extends TextBitmapRenderer {
        @Override
        public BoundingBox3d drawText(GL gl, GLU glu, Camera cam, String text, Coord3d position, Halign halign, Valign valign, Color color, Coord2d screenOffset, Coord3d sceneOffset, int type) {
            Coord3d posReal;
            this.color(gl, color);
            Coord3d posScreen = cam.modelToScreen(gl, glu, position);
            float strlen = glut.glutBitmapLength(font1, text);
            float x = this.computeXWithAlign(halign, posScreen, strlen, 0.0f);
            float y = this.computeYWithAlign(valign, posScreen, 0.0f);
            Coord3d posScreenShifted = new Coord3d(x + screenOffset.x, y + screenOffset.y, posScreen.z);
            try {
                posReal = cam.screenToModel(gl, glu, posScreenShifted);
            }
            catch (RuntimeException e) {
                System.err.println("TextBitmap.drawText(): could not process text position: " + posScreen + " " + posScreenShifted);
                return new BoundingBox3d();
            }
            this.rotateText(gl, posReal);
            this.glRasterPos(gl, sceneOffset, Coord3d.ORIGIN);
            glut.glutBitmapString(font1, text);
            return this.computeTextBounds(gl, glu, cam, posScreenShifted, strlen);
        }

        public void rotateText(GL gl, Coord3d posReal) {
            gl.getGL2().glPushMatrix();
            gl.getGL2().glMatrixMode(5888);
            this.loadIdentity(gl);
            this.rotateOf(gl, 90.0, 2);
            this.translateTo(gl, posReal, false);
            gl.getGL2().glScalef(((AxeBox2d)AxeBox2d.this).scale.x, ((AxeBox2d)AxeBox2d.this).scale.y, ((AxeBox2d)AxeBox2d.this).scale.z);
            gl.getGL2().glPopMatrix();
        }

        public void loadIdentity(GL gl) {
            gl.getGL2().glLoadIdentity();
        }

        public void rotateOf(GL gl, double angle, int axis) {
            gl.getGL2().glRotatef((float)angle, 0.0f, 0.0f, 1.0f);
        }

        public void translateTo(GL gl, Coord3d position, boolean reverse) {
            if (gl.isGLES()) {
                float reverseCoef = reverse ? -1.0f : 1.0f;
                GLES2CompatUtils.glTranslatef(reverseCoef * position.x, reverseCoef * position.y, reverseCoef * position.z);
            } else if (reverse) {
                gl.getGL2().glTranslatef(-position.x, -position.y, -position.z);
            } else {
                gl.getGL2().glTranslatef(position.x, position.y / 2.0f, position.z);
            }
        }
    }
}

