/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.thread.camera;

import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.maths.Coord2d;

public class CameraThreadController
extends AbstractCameraController
implements Runnable {
    protected Coord2d move;
    protected Thread process = null;
    protected int sleep = 1;
    protected float step = 5.0E-4f;

    public CameraThreadController() {
    }

    public CameraThreadController(Chart chart) {
        this.register(chart);
    }

    @Override
    public void dispose() {
        this.stop();
        super.dispose();
    }

    public void start() {
        if (this.process == null) {
            this.process = new Thread(this);
            this.process.setName("Embedded by ChartThreadController");
            this.process.start();
        }
    }

    public void stop() {
        if (this.process != null) {
            this.process.interrupt();
            this.process = null;
        }
    }

    @Override
    public void run() {
        this.doRun();
    }

    protected void doRun() {
        this.move = new Coord2d(this.step, 0.0f);
        while (this.process != null) {
            try {
                this.rotate(this.move);
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {
                this.process = null;
            }
        }
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        this.step = step;
    }
}

