/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.picking;

import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.ControllerType;
import org.jzy3d.chart.controllers.mouse.picking.AWTMousePickingController;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.view.View;

public class AWTMousePickingPan2dController<V, E>
extends AWTMousePickingController<V, E> {
    protected boolean done;
    protected static float PAN_FACTOR = 0.25f;
    protected int lastMouseX = 0;
    protected int lastMouseY = 0;

    public AWTMousePickingPan2dController() {
    }

    public AWTMousePickingPan2dController(Chart chart) {
        super(chart);
    }

    public AWTMousePickingPan2dController(Chart chart, int brushSize) {
        super(chart, brushSize);
    }

    public AWTMousePickingPan2dController(Chart chart, int brushSize, int bufferSize) {
        super(chart, brushSize, bufferSize);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int yflip = -e.getY() + ((Chart)this.targets.get(0)).getCanvas().getRendererHeight();
        Coord2d mouse = new Coord2d(e.getX(), yflip);
        View view = ((Chart)this.targets.get(0)).getView();
        Coord3d thisMouse3d = view.projectMouse(e.getX(), yflip);
        if (!this.done) {
            this.pan(this.prevMouse3d, thisMouse3d);
            this.done = true;
        } else {
            this.done = false;
        }
        this.prevMouse = mouse;
        this.prevMouse3d = thisMouse3d;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.lastInc = (float)e.getWheelRotation() / 10.0f;
        this.factor += this.lastInc;
        View view = ((Chart)this.targets.get(0)).getView();
        this.mouse3d = view.projectMouse(this.lastMouseX, this.lastMouseY);
        this.zoom(1.0f + this.lastInc);
    }

    protected void zoom(float factor) {
        Chart chart = (Chart)this.targets.get(0);
        BoundingBox3d viewBounds = chart.getView().getBounds();
        BoundingBox3d newBounds = viewBounds.scale(new Coord3d(factor, factor, 1.0f));
        chart.getView().setBoundManual(newBounds);
        chart.getView().shoot();
        this.fireControllerEvent(ControllerType.ZOOM, Float.valueOf(factor));
    }

    protected void pan(Coord3d from, Coord3d to) {
        Chart chart = (Chart)this.targets.get(0);
        BoundingBox3d viewBounds = chart.getView().getBounds();
        Coord3d offset = to.sub(from).div(-PAN_FACTOR);
        BoundingBox3d newBounds = viewBounds.shift(offset);
        chart.getView().setBoundManual(newBounds);
        chart.getView().shoot();
        this.fireControllerEvent(ControllerType.PAN, offset);
    }
}

