/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.jzy3d.chart.AWTChart;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.mouse.camera.AWTCameraMouseController;
import org.jzy3d.chart.controllers.mouse.selection.AWTAbstractMouseSelector;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.plot3d.rendering.view.Renderer2d;

public class AWTDualModeMouseSelector {
    protected Chart chart;
    protected Renderer2d messageRenderer;
    protected CameraThreadController threadCamera;
    protected AWTCameraMouseController mouseCamera;
    protected AWTAbstractMouseSelector mouseSelection;
    protected boolean displayMessage = true;
    protected String message;
    public static String MESSAGE_SELECTION_MODE = "Current mouse mode: selection (hold 'c' to switch to camera mode)";
    public static String MESSAGE_ROTATION_MODE = "Current mouse mode: camera (release 'c' to switch to selection mode)";

    public AWTDualModeMouseSelector(Chart chart, AWTAbstractMouseSelector alternativeMouse) {
        this.build(chart, alternativeMouse);
    }

    public Chart build(Chart chart, AWTAbstractMouseSelector alternativeMouse) {
        this.chart = chart;
        this.mouseSelection = alternativeMouse;
        this.threadCamera = new CameraThreadController(chart);
        this.mouseCamera = new AWTCameraMouseController(chart);
        this.mouseCamera.addSlaveThreadController(this.threadCamera);
        chart.getCanvas().addKeyController(this.buildToggleKeyListener(chart));
        this.releaseCam();
        this.message = MESSAGE_SELECTION_MODE;
        this.messageRenderer = this.buildMessageRenderer();
        this.getAWTChart(chart).addRenderer(this.messageRenderer);
        return chart;
    }

    private AWTChart getAWTChart(Chart chart) {
        return (AWTChart)chart;
    }

    public KeyListener buildToggleKeyListener(final Chart chart) {
        return new KeyListener(){
            protected boolean holding = false;

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case 'c': {
                        AWTDualModeMouseSelector.this.releaseCam();
                        this.holding = false;
                        AWTDualModeMouseSelector.this.message = MESSAGE_SELECTION_MODE;
                        break;
                    }
                }
                chart.render();
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (!this.holding) {
                    switch (e.getKeyChar()) {
                        case 'c': {
                            AWTDualModeMouseSelector.this.useCam();
                            AWTDualModeMouseSelector.this.mouseSelection.clearLastSelection();
                            this.holding = true;
                            AWTDualModeMouseSelector.this.message = MESSAGE_ROTATION_MODE;
                            break;
                        }
                    }
                    chart.render();
                }
            }
        };
    }

    public Renderer2d buildMessageRenderer() {
        return new Renderer2d(){

            @Override
            public void paint(Graphics g) {
                if (AWTDualModeMouseSelector.this.displayMessage && AWTDualModeMouseSelector.this.message != null) {
                    g.setColor(Color.RED);
                    g.drawString(AWTDualModeMouseSelector.this.message, 10, 30);
                }
            }
        };
    }

    protected void useCam() {
        this.mouseSelection.unregister();
        this.chart.addController(this.mouseCamera);
    }

    protected void releaseCam() {
        this.chart.removeController(this.mouseCamera);
        this.mouseSelection.register(this.chart);
    }
}

