/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.bridge.newt.controllers.mouse;

import com.jogamp.newt.event.MouseListener;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jzy3d.bridge.newt.controllers.AWTToNewtUtilities;

public class AWTToNewtMouseListener
implements MouseListener {
    private final java.awt.event.MouseListener mouseListener;
    private final MouseMotionListener mouseMotionListener;
    private final MouseWheelListener mouseWheelListener;
    private final Component source;

    public AWTToNewtMouseListener(Component source, java.awt.event.MouseListener mouseListener, MouseMotionListener mouseMotionListener, MouseWheelListener mouseWheelListener) {
        this.source = source;
        this.mouseListener = mouseListener;
        this.mouseMotionListener = mouseMotionListener;
        this.mouseWheelListener = mouseWheelListener;
    }

    protected MouseEvent convertEvent(com.jogamp.newt.event.MouseEvent event, int id) {
        return new MouseEvent(this.source, id, event.getWhen(), AWTToNewtUtilities.mask(event), event.getX(), event.getY(), event.getClickCount(), false, event.getButton());
    }

    protected MouseWheelEvent convertWheelEvent(com.jogamp.newt.event.MouseEvent event, int id) {
        int direction = event.getRotation()[1] > 0.0f ? -1 : 1;
        int units = Math.round(event.getRotation()[1] * event.getRotationScale());
        return new MouseWheelEvent(this.source, id, event.getWhen(), AWTToNewtUtilities.mask(event), event.getX(), event.getY(), (int)event.getClickCount(), false, 0, units, direction);
    }

    @Override
    public void mouseClicked(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseClicked(this.convertEvent(me, 500));
        }
    }

    @Override
    public void mouseEntered(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseEntered(this.convertEvent(me, 504));
        }
    }

    @Override
    public void mouseExited(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseExited(this.convertEvent(me, 505));
        }
    }

    @Override
    public void mousePressed(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mousePressed(this.convertEvent(me, 501));
        }
    }

    @Override
    public void mouseReleased(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseReleased(this.convertEvent(me, 502));
        }
    }

    @Override
    public void mouseMoved(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseMoved(this.convertEvent(me, 503));
        }
    }

    @Override
    public void mouseDragged(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseMotionListener != null) {
            this.mouseMotionListener.mouseDragged(this.convertEvent(me, 506));
        }
    }

    @Override
    public void mouseWheelMoved(com.jogamp.newt.event.MouseEvent me) {
        if (this.mouseWheelListener != null) {
            this.mouseWheelListener.mouseWheelMoved(this.convertWheelEvent(me, 507));
        }
    }
}

