/*
 * Decompiled with CFR 0.152.
 */
package probrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import probrowser.HighlightTableCellRenderer;

public class MainPanel
extends JPanel {
    private static final Color warningColor = new Color(255, 200, 200);
    private final JTextField field;
    private final HighlightTableCellRenderer renderer = new HighlightTableCellRenderer();
    private TableModel model;
    private TableRowSorter<TableModel> sorter;
    private JTable table;

    public MainPanel(JTable table) {
        super(new BorderLayout(5, 5));
        this.field = new JTextField("");
        this.table = table;
        this.model = table.getModel();
        this.sorter = new TableRowSorter<TableModel>(this.model);
        table.setFillsViewportHeight(true);
        table.setDefaultRenderer(String.class, this.renderer);
        this.field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MainPanel.this.fireDocumentChangeEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MainPanel.this.fireDocumentChangeEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.fireDocumentChangeEvent();
        JPanel sp = new JPanel(new BorderLayout(5, 5));
        sp.add((Component)new JLabel("Search (Regex Pattern):"), "West");
        sp.add(this.field);
        sp.add(Box.createVerticalStrut(2), "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)sp, "North");
        this.add(new JScrollPane(table));
        this.setPreferredSize(new Dimension(320, 240));
    }

    private void fireDocumentChangeEvent() {
        this.model = this.table.getModel();
        this.sorter = new TableRowSorter<TableModel>(this.model);
        this.field.setBackground(Color.WHITE);
        String pattern = this.field.getText().trim();
        if (pattern.isEmpty()) {
            this.sorter.setRowFilter(null);
            this.renderer.setPattern("");
        } else if (this.renderer.setPattern(pattern)) {
            try {
                this.sorter.setRowFilter(RowFilter.regexFilter(pattern, new int[0]));
            }
            catch (PatternSyntaxException ex) {
                this.field.setBackground(warningColor);
            }
        }
        this.table.repaint();
    }
}

