/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.AstroOps;
import com.mhuss.AstroLib.NoInitException;
import com.mhuss.AstroLib.ObsInfo;
import com.mhuss.AstroLib.PlanetData;
import com.mhuss.AstroLib.TimePair;

public class RiseSet {
    public static final int SUN = 0;
    public static final int MOON = 1;
    public static final int CIVIL_TWI = 2;
    public static final int NAUTICAL_TWI = 3;
    public static final int ASTRONOMICAL_TWI = 4;
    public static final double SUN_ALT = Math.toRadians(-0.83333);
    public static final double SUN_TOPO_ALT = Math.toRadians(-0.83555);
    public static final double MOON_ALT = Math.toRadians(0.125);
    public static final double PLANET_ALT = Math.toRadians(-0.57);
    public static final double C_TWI_ALT = Math.toRadians(-6.0);
    public static final double N_TWI_ALT = Math.toRadians(-12.0);
    public static final double A_TWI_ALT = Math.toRadians(-18.0);
    public static final int UNKNOWN = 0;
    public static final int RISING = 1;
    public static final int SETTING = 2;
    public static final int CULMINATING = 3;

    public static TimePair getTimes(int rsType, double jd, ObsInfo oi, PlanetData pd) {
        int i;
        double risesetAlt = SUN_ALT;
        int planet = 3;
        switch (rsType) {
            case 1: {
                risesetAlt = MOON_ALT;
                planet = 10;
                break;
            }
            case 2: {
                risesetAlt = C_TWI_ALT;
                break;
            }
            case 3: {
                risesetAlt = N_TWI_ALT;
                break;
            }
            case 4: {
                risesetAlt = A_TWI_ALT;
                break;
            }
        }
        TimePair riseSet = new TimePair(-1.0, -1.0);
        double[] altitude = new double[25];
        for (i = 0; i <= 24; ++i) {
            pd.calc(planet, jd + AstroOps.toDays(i), oi);
            try {
                altitude[i] = pd.getAltAzLat() - risesetAlt;
                continue;
            }
            catch (NoInitException noInitException) {
                // empty catch block
            }
        }
        for (i = 0; i < 24; ++i) {
            int rs = 0;
            if (altitude[i] <= 0.0 && altitude[i + 1] > 0.0) {
                rs = 1;
            } else if (altitude[i] > 0.0 && altitude[i + 1] <= 0.0) {
                rs = 2;
            }
            if (false == rs) continue;
            double fraction = AstroOps.toDays(i);
            double alt0 = altitude[i];
            double altDiff = altitude[i + 1] - alt0;
            double delta = 1.0;
            int iterations = 10;
            while (delta > 1.0E-4 && iterations > 0) {
                --iterations;
                delta = -alt0 / altDiff / 24.0;
                pd.calc(planet, jd + (fraction += delta), oi);
                try {
                    alt0 = pd.getAltAzLat() - risesetAlt;
                }
                catch (NoInitException noInitException) {}
            }
            if (1 == rs) {
                riseSet.a = fraction;
                continue;
            }
            if (2 != rs) continue;
            riseSet.b = fraction;
        }
        return riseSet;
    }

    public static TimePair getTimes(int rsType, double jd, ObsInfo oi) {
        return RiseSet.getTimes(rsType, jd, oi, new PlanetData());
    }
}

