/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.AstroOps;
import com.mhuss.AstroLib.DateOps;
import com.mhuss.AstroLib.Latitude;
import com.mhuss.AstroLib.Longitude;
import com.mhuss.AstroLib.Lunar;
import com.mhuss.AstroLib.NoInitException;
import com.mhuss.AstroLib.ObsInfo;
import com.mhuss.AstroLib.PlanetData;
import com.mhuss.AstroLib.RiseSet;
import com.mhuss.AstroLib.TimeOps;
import com.mhuss.AstroLib.TimePair;
import com.mhuss.AstroLib.Vsop;
import java.util.GregorianCalendar;

public class LunarCalc {
    public static final double SYNODIC_MONTH = 29.530588861;
    static final double LUNATION_BASE = 2423436.40347;

    public static double ageOfMoonInDays(double jd) {
        double centuries = AstroOps.toMillenia(jd);
        double earthLon = Vsop.calcLE(centuries, 3, 1);
        double sunLon = earthLon + Math.PI;
        Lunar luna = new Lunar(centuries);
        double moonLon = -1.0;
        try {
            moonLon = luna.getLongitudeRadians();
        }
        catch (NoInitException noInitException) {
            // empty catch block
        }
        double moonAge = AstroOps.normalizeRadians(Math.PI * 2 - (sunLon - moonLon));
        double sday = 29.530588861 * (moonAge / (Math.PI * 2));
        return sday;
    }

    public static double ageOfMoonInDays(GregorianCalendar cal) {
        return LunarCalc.ageOfMoonInDays((double)DateOps.dmyToDay(cal.get(5), cal.get(2) + 1, cal.get(1)) + AstroOps.toDays(cal.get(11) + TimeOps.tzOffset()));
    }

    public static double ageOfMoonInDays() {
        return LunarCalc.ageOfMoonInDays(new GregorianCalendar());
    }

    public static int lunation(long jd) {
        int lun = (int)(((double)jd - 2423436.40347) / 29.530588861);
        return ++lun;
    }

    public static int lunation(GregorianCalendar cal) {
        return LunarCalc.lunation(DateOps.dmyToDay(cal.get(5), cal.get(2) + 1, cal.get(1)));
    }

    public static int lunation() {
        return LunarCalc.lunation(new GregorianCalendar());
    }

    public static String summary(ObsInfo oi) {
        GregorianCalendar now = new GregorianCalendar();
        double age = LunarCalc.ageOfMoonInDays(now);
        int iDays = (int)age;
        int iHours = (int)((age - (double)iDays) * 24.0 + 0.5);
        String info = "Lunation " + LunarCalc.lunation(now) + ", age " + iDays + "d " + iHours + "h, \n";
        double offset = TimeOps.tzOffsetInDays() + TimeOps.dstOffsetInDays(now) + 0.5;
        double jd = (double)DateOps.calendarToDay(now) - offset;
        TimePair rs = RiseSet.getTimes(1, jd, oi, new PlanetData());
        String setSpace = "";
        if (rs.a >= 0.0) {
            info = info + "Rises " + TimeOps.formatTime(rs.a);
            setSpace = " ";
        }
        if (rs.b >= 0.0) {
            info = info + setSpace + "Sets " + TimeOps.formatTime(rs.b);
        }
        return info;
    }

    public static String summaryPHL() {
        return LunarCalc.summary(new ObsInfo(new Latitude(39.95), new Longitude(-75.16))) + " (Phila, PA)";
    }

    private static double calcDiff(PlanetData pd, double jd, ObsInfo loc) {
        return pd.calcLon(10, jd, loc) - pd.calcLon(3, jd, loc);
    }

    private static boolean quadDiff(double a1, double a2) {
        return AstroOps.quadrant(a1) != AstroOps.quadrant(a2);
    }

    public static double quarterChange(double jd, ObsInfo loc) {
        double[] longitude = new double[25];
        PlanetData pd = new PlanetData();
        for (int i = 0; i <= 24; ++i) {
            longitude[i] = LunarCalc.calcDiff(pd, jd + AstroOps.toDays(i), loc);
        }
        double fraction = -1.0;
        for (int i = 0; i < 24; ++i) {
            double lonBase;
            if (!LunarCalc.quadDiff(longitude[i + 1], longitude[i])) continue;
            double delta = 1.0;
            int iterations = 10;
            fraction = AstroOps.toDays(i);
            double lonCur = lonBase = longitude[i];
            while (delta > 1.0E-4 && iterations > 0) {
                System.out.println("...frac=" + (fraction += (delta /= 24.0)) + ", delta=" + delta);
                lonCur = LunarCalc.calcDiff(pd, jd + fraction, loc);
                if (!LunarCalc.quadDiff(lonBase, lonCur)) continue;
                --iterations;
            }
            break;
        }
        return fraction;
    }

    public static void main(String[] args) {
        int i;
        System.out.println("LunarCalc Test");
        GregorianCalendar gc = new GregorianCalendar();
        for (i = 11; i < 17; ++i) {
            gc.set(2002, 2, i);
            System.out.println("Lunation on 3/" + i + ": " + LunarCalc.lunation(gc));
        }
        for (i = 9; i < 16; ++i) {
            gc.set(2002, 3, i);
            System.out.println("Lunation on 4/" + i + ": " + LunarCalc.lunation(gc));
        }
        System.out.println(LunarCalc.summaryPHL());
    }
}

