/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.AstroDate;
import com.mhuss.AstroLib.AstroOps;
import com.mhuss.AstroLib.DateOps;
import com.mhuss.AstroLib.LocationElements;
import com.mhuss.AstroLib.LunarFundamentals;
import com.mhuss.AstroLib.LunarTerms;
import com.mhuss.AstroLib.LunarTermsLat;
import com.mhuss.AstroLib.LunarTermsLonRad;
import com.mhuss.AstroLib.LunarTermsPh;
import com.mhuss.AstroLib.LunarUnitCheck;
import com.mhuss.AstroLib.NoInitException;
import com.mhuss.AstroLib.TimeOps;
import java.util.Calendar;

public class Lunar {
    public static final int NEW = 0;
    public static final int Q1 = 1;
    public static final int FULL = 2;
    public static final int Q3 = 3;
    private LunarFundamentals m_f;
    private LunarUnitCheck m_uc;
    private boolean m_initialized;
    private LocationElements m_LEs = new LocationElements();
    private static final String NoInit = "Call Lunar.calcFundamentals() first.";

    public Lunar() {
        this.m_initialized = false;
    }

    public Lunar(double t) {
        this.calcFundamentals(t);
    }

    public void calcFundamentals(double t) {
        if (null == this.m_f) {
            this.m_f = new LunarFundamentals();
        }
        this.m_f.Lp = Lunar.getFund(LunarTerms.LunarFundimentals_Lp, t);
        this.m_f.D = Lunar.getFund(LunarTerms.LunarFundimentals_D, t);
        this.m_f.M = Lunar.getFund(LunarTerms.LunarFundimentals_M, t);
        this.m_f.Mp = Lunar.getFund(LunarTerms.LunarFundimentals_Mp, t);
        this.m_f.F = Lunar.getFund(LunarTerms.LunarFundimentals_F, t);
        this.m_f.A1 = Lunar.toNormalizedRadians(119.75 + 131.849 * t);
        this.m_f.A2 = Lunar.toNormalizedRadians(53.09 + 479264.29 * t);
        this.m_f.A3 = Lunar.toNormalizedRadians(313.45 + 481266.484 * t);
        this.m_f.T = t;
        if (null == this.m_uc) {
            this.m_uc = new LunarUnitCheck();
        }
        this.m_LEs.invalidate();
        this.m_initialized = true;
    }

    public double phaseAngle() throws NoInitException {
        if (!this.m_initialized) {
            throw new NoInitException(NoInit);
        }
        return Lunar.toNormalizedRadians(180.0 - Math.toDegrees(this.m_f.D) - 6.289 * Math.sin(this.m_f.Mp) + 2.11 * Math.sin(this.m_f.M) - 1.274 * Math.sin(2.0 * this.m_f.D - this.m_f.Mp) - 0.658 * Math.sin(2.0 * this.m_f.D) - 0.214 * Math.sin(2.0 * this.m_f.Mp) - 0.11 * Math.sin(this.m_f.D));
    }

    public double illuminatedFraction() throws NoInitException {
        if (!this.m_initialized) {
            throw new NoInitException(NoInit);
        }
        return (1.0 + Math.cos(this.phaseAngle())) / 2.0;
    }

    public static double getPhase(long jd, int quarter, Calendar cal) {
        int nTerms;
        LunarTermsPh[] terms;
        if (quarter < 0) {
            quarter = 0;
        }
        if (quarter > 3) {
            quarter = 3;
        }
        boolean newOrFull = 0 == quarter || 2 == quarter;
        double T = AstroOps.toMillenia(jd);
        double k = Math.floor(T * 1236.85) + (double)quarter / 4.0;
        double E = 1.0 - 0.002516 * T - 7.4E-6 * T * T;
        double JDE = 2451550.09766 + 29.530588861 * k + 1.5437E-4 * T * T - 1.5E-7 * T * T * T + 7.3E-10 * T * T * T * T + 0.5;
        if (null != cal) {
            JDE += TimeOps.tzOffsetInDays(cal);
        }
        double M = Lunar.getFund(LunarTerms.PhaseFundimentals_M, k, T);
        double Mp = Lunar.getFund(LunarTerms.PhaseFundimentals_Mp, k, T);
        double F = Lunar.getFund(LunarTerms.PhaseFundimentals_F, k, T);
        double Om = Lunar.getFund(LunarTerms.PhaseFundimentals_Om, k, T);
        if (newOrFull) {
            terms = LunarTerms.LunarPhaseNF;
            nTerms = LunarTerms.LunarPhaseNF.length;
        } else {
            terms = LunarTerms.LunarPhaseQ;
            nTerms = LunarTerms.LunarPhaseQ.length;
        }
        double correction = 0.0;
        for (int i = 0; i < nTerms; ++i) {
            double sumOfPeriodicArguments = M * (double)terms[i].m;
            sumOfPeriodicArguments += Mp * (double)terms[i].mp;
            sumOfPeriodicArguments += F * (double)terms[i].f;
            double phasePeriodicTerm = Math.sin(sumOfPeriodicArguments += Om * (double)terms[i].om) * terms[i].nm;
            for (int e = terms[i].e; e > 0; --e) {
                phasePeriodicTerm *= E;
            }
            correction += phasePeriodicTerm;
        }
        JDE += correction;
        if (!newOrFull) {
            double W = 0.00306 - 3.8E-4 * E * Math.cos(M) + 2.6E-4 * Math.cos(Mp) - 2.0E-5 * Math.cos(Mp - M) + 2.0E-5 * Math.cos(Mp + M) + 2.0E-5 * Math.cos(F + F);
            JDE += 1 == quarter ? W : -W;
        }
        JDE += 3.25E-4 * Math.sin(Math.toRadians(299.77 + 0.107408 * k - 0.009173 * T * T));
        JDE += 1.65E-4 * Math.sin(Math.toRadians(251.88 + 0.016321 * k));
        JDE += 1.64E-4 * Math.sin(Math.toRadians(251.83 + 26.651886 * k));
        JDE += 1.26E-4 * Math.sin(Math.toRadians(349.42 + 36.412478 * k));
        JDE += 1.1E-4 * Math.sin(Math.toRadians(84.66 + 18.206239 * k));
        JDE += 6.2E-5 * Math.sin(Math.toRadians(141.74 + 53.303772 * k));
        JDE += 6.0E-5 * Math.sin(Math.toRadians(207.14 + 2.453732 * k));
        JDE += 5.6E-5 * Math.sin(Math.toRadians(154.84 + 7.30686 * k));
        JDE += 4.7E-5 * Math.sin(Math.toRadians(34.52 + 27.261239 * k));
        JDE += 4.2E-5 * Math.sin(Math.toRadians(207.19 + 0.121824 * k));
        JDE += 4.0E-5 * Math.sin(Math.toRadians(291.34 + 1.844379 * k));
        JDE += 3.7E-5 * Math.sin(Math.toRadians(161.72 + 24.198154 * k));
        JDE += 3.5E-5 * Math.sin(Math.toRadians(239.56 + 25.513099 * k));
        return JDE += 2.3E-5 * Math.sin(Math.toRadians(331.55 + 3.592518 * k));
    }

    public static double getPhase(long jd, int quarter) {
        return Lunar.getPhase(jd, quarter, null);
    }

    public double getLatitude() throws NoInitException {
        if (!this.m_initialized) {
            throw new NoInitException(NoInit);
        }
        double latitude = this.m_LEs.getLatitude();
        if (latitude < 0.0) {
            double e;
            LunarTermsLat[] tptr = LunarTerms.LunarLat;
            double sumLatitudeTerms = 0.0;
            this.m_uc.E = e = 1.0 - 0.002516 * this.m_f.T - 7.4E-6 * this.m_f.T * this.m_f.T;
            for (int i = 0; i < tptr.length; ++i) {
                double sumOfPeriodicArguments = (double)tptr[i].d * this.m_f.D;
                sumOfPeriodicArguments += (double)tptr[i].m * this.m_f.M;
                sumOfPeriodicArguments += (double)tptr[i].mp * this.m_f.Mp;
                double latitudePeriodicTerm = (double)tptr[i].sb * Math.sin(sumOfPeriodicArguments += (double)tptr[i].f * this.m_f.F);
                for (int j = Math.abs(tptr[i].m); j != 0; --j) {
                    latitudePeriodicTerm *= e;
                }
                sumLatitudeTerms += latitudePeriodicTerm;
            }
            this.m_uc.sumLatitudeTerms = sumLatitudeTerms += -2235.0 * Math.sin(this.m_f.Lp) + 382.0 * Math.sin(this.m_f.A3) + 175.0 * Math.sin(this.m_f.A1 - this.m_f.F) + 175.0 * Math.sin(this.m_f.A1 + this.m_f.F) + 127.0 * Math.sin(this.m_f.Lp - this.m_f.Mp) - 115.0 * Math.sin(this.m_f.Lp + this.m_f.Mp);
            latitude = sumLatitudeTerms * 1.0E-6;
            this.m_LEs.setLatitude(latitude);
        }
        return latitude;
    }

    public double getLatitudeRadians() throws NoInitException {
        if (!this.m_initialized) {
            throw new NoInitException(NoInit);
        }
        return Math.toRadians(this.getLatitude());
    }

    public double getLongitude() throws NoInitException {
        if (this.m_LEs.getLongitude() < 0.0) {
            this.calcLonRad();
        }
        return this.m_LEs.getLongitude();
    }

    public double getLongitudeRadians() throws NoInitException {
        if (!this.m_initialized) {
            throw new NoInitException(NoInit);
        }
        return Math.toRadians(this.getLongitude());
    }

    public double getRadius() throws NoInitException {
        if (this.m_LEs.getRadius() < 0.0) {
            this.calcLonRad();
        }
        return this.m_LEs.getRadius();
    }

    public void calcAllLEs(LocationElements locs, double t) throws NoInitException {
        this.calcFundamentals(t);
        locs.set(this.getLatitudeRadians(), this.getLongitudeRadians(), this.getRadius());
    }

    private static double toNormalizedRadians(double d) {
        return Math.toRadians(AstroOps.normalizeDegrees(d));
    }

    private static double getFund(double[] fundArray, double t) {
        double d = fundArray[0];
        double tpow = t;
        for (int i = 1; i < 5; ++i) {
            d += tpow * fundArray[i];
            tpow *= t;
        }
        return Lunar.toNormalizedRadians(d);
    }

    private static double getFund(double[] fundArray, double k, double t) {
        double d = fundArray[0] + k * fundArray[1];
        double tpow = t * t;
        for (int i = 2; i < 5; ++i) {
            d += tpow * fundArray[i];
            tpow *= t;
        }
        return Lunar.toNormalizedRadians(d);
    }

    private void calcLonRad() throws NoInitException {
        if (!this.m_initialized) {
            this.m_LEs.setLongitude(-1.0);
            this.m_LEs.setRadius(-1.0);
            throw new NoInitException(NoInit);
        }
        LunarTermsLonRad[] tptr = LunarTerms.LunarLonRad;
        double sumLongitudeTerms = 0.0;
        double sumRangeTerms = 0.0;
        double e = 1.0 - 0.002516 * this.m_f.T - 7.4E-6 * this.m_f.T * this.m_f.T;
        for (int i = 0; i < tptr.length; ++i) {
            double sumOfPeriodicArguments = (double)tptr[i].d * this.m_f.D;
            sumOfPeriodicArguments += (double)tptr[i].m * this.m_f.M;
            sumOfPeriodicArguments += (double)tptr[i].mp * this.m_f.Mp;
            double longitudePeriodicTerm = (double)tptr[i].sl * Math.sin(sumOfPeriodicArguments += (double)tptr[i].f * this.m_f.F);
            for (int j = Math.abs(tptr[i].m); j != 0; --j) {
                longitudePeriodicTerm *= e;
            }
            sumLongitudeTerms += longitudePeriodicTerm;
            double rangePeriodicTerm = (double)tptr[i].sr * Math.cos(sumOfPeriodicArguments);
            for (int j = Math.abs(tptr[i].m); j != 0; --j) {
                rangePeriodicTerm *= e;
            }
            sumRangeTerms += rangePeriodicTerm;
        }
        this.m_uc.sumLongitudeTerms = sumLongitudeTerms += 3958.0 * Math.sin(this.m_f.A1) + 1962.0 * Math.sin(this.m_f.Lp - this.m_f.F) + 318.0 * Math.sin(this.m_f.A2);
        this.m_uc.sumRangeTerms = sumRangeTerms;
        double longitude = this.m_f.Lp * 180.0 / Math.PI + sumLongitudeTerms * 1.0E-6;
        this.m_LEs.setLongitude(AstroOps.normalizeDegrees(longitude));
        this.m_LEs.setRadius(385000.56 + sumRangeTerms / 1000.0);
    }

    private static double roundTo(double number, int decimalPlaces) {
        String zeros128 = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
        long roundingFactor = Math.round(Math.pow(10.0, decimalPlaces));
        long roundedNumber = Math.abs(Math.round(number *= (double)roundingFactor));
        long integerPart = roundedNumber / roundingFactor;
        long decimalPart = roundedNumber % roundingFactor;
        String temp = "" + decimalPart;
        String decimalString = decimalPlaces > temp.length() ? "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000".substring(0, decimalPlaces - temp.length()) + temp : "" + temp;
        String rounded = "" + integerPart + "." + decimalString + "E0";
        double returnValue = new Double(rounded);
        if (number < 0.0) {
            returnValue = -returnValue;
        }
        return returnValue;
    }

    public static void main(String[] args) {
        long jDay = DateOps.dmyToDay(14, 2, 1977);
        System.out.println("\n\n*** Unit test phase calc using Meeus' example ***\njulianDay = " + jDay);
        AstroDate ad = new AstroDate(Lunar.getPhase(jDay, 0));
        System.out.println("Ref  date/time: 1977-02-18 03:37:42\nCalc date/time: " + ad);
        double JULIAN_DAY_1992 = 2448724.5;
        double julianDay = 2448724.5;
        System.out.println("\n\n*** Unit test position calc using Meeus' example ***\njulianDay = " + julianDay);
        double daysSinceEpoch = julianDay - new AstroDate().jd();
        double latitude = 0.0;
        double longitude = 0.0;
        double radius = 0.0;
        Lunar moon = new Lunar();
        LocationElements le = new LocationElements();
        try {
            moon.calcAllLEs(le, daysSinceEpoch / 36525.0);
            double T = Lunar.roundTo(moon.m_f.T, 12);
            System.out.println("T = " + T + "  \"error\" = " + (T + 0.077221081451));
            double Lp = Lunar.roundTo(Math.toDegrees(moon.m_f.Lp), 6);
            System.out.println("Lp = " + Lp + "  diff = " + (Lp - 134.290182));
            double D = Lunar.roundTo(Math.toDegrees(moon.m_f.D), 6);
            System.out.println("D = " + D + "  diff = " + (D - 113.842304));
            double M = Lunar.roundTo(Math.toDegrees(moon.m_f.M), 6);
            System.out.println("M = " + M + "  diff = " + (M - 97.643514));
            double Mp = Lunar.roundTo(Math.toDegrees(moon.m_f.Mp), 6);
            System.out.println("Mp = " + Mp + "  diff = " + (Mp - 5.150833));
            double F = Lunar.roundTo(Math.toDegrees(moon.m_f.F), 6);
            System.out.println("F = " + F + "  diff = " + (F - 219.889721));
            double A1 = Lunar.roundTo(Math.toDegrees(moon.m_f.A1), 2);
            System.out.println("A1 = " + A1 + "  diff = " + (A1 - 109.57));
            double A2 = Lunar.roundTo(Math.toDegrees(moon.m_f.A2), 2);
            System.out.println("A2 = " + A2 + "  diff = " + (A2 - 123.78));
            double A3 = Lunar.roundTo(Math.toDegrees(moon.m_f.A3), 2);
            System.out.println("A3 = " + A3 + "  diff = " + (A3 - 229.53));
            double E = Lunar.roundTo(moon.m_uc.E, 6);
            System.out.println("E = " + E + "  diff = " + (E - 1.000194));
            double sumLongitudeTerms = Lunar.roundTo(moon.m_uc.sumLongitudeTerms, 0);
            System.out.println("sumLongitudeTerms = " + sumLongitudeTerms + "  diff = " + (sumLongitudeTerms + 1127527.0));
            double sumLatitudeTerms = Lunar.roundTo(moon.m_uc.sumLatitudeTerms, 0);
            System.out.println("sumLatitudeTerms = " + sumLatitudeTerms + "  diff = " + (sumLatitudeTerms + 3229126.0));
            double sumRangeTerms = Lunar.roundTo(moon.m_uc.sumRangeTerms, 0);
            System.out.println("sumRangeTerms = " + sumRangeTerms + "  diff = " + (sumRangeTerms + 1.6590875E7));
            latitude = Lunar.roundTo(moon.getLatitude(), 6);
            longitude = Lunar.roundTo(moon.getLongitude(), 6);
            radius = Lunar.roundTo(moon.getRadius(), 1);
            System.out.println("lat: " + latitude + "  diff = " + (latitude + 3.229126));
            System.out.println("long: " + longitude + "  diff = " + (longitude - 133.162655));
            System.out.println("rad: " + radius + "  diff = " + (radius - 368409.7));
        }
        catch (NoInitException noInitException) {
            // empty catch block
        }
    }
}

