/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday.defaultimpl;

import java.util.Calendar;
import junit.framework.TestCase;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.util.ISDADateFormat;

public class MonthEndReferenceOffsetTest
extends TestCase {
    private Calendar startCalendar = null;
    private HolidayCalendar wend = null;
    private BusinessDayConvention convention = null;

    protected void setUp() throws Exception {
        this.startCalendar = ISDADateFormat.parse("2006/9/27");
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        this.wend = holidayCalendarFactory.getHolidayCalendar("WE");
        this.convention = BusinessDayConvention.MONTH_END_REFERENCE;
    }

    public void testSpot() {
        String target = "2006/9/29";
        String adjusted = ISDADateFormat.format(this.wend.adjust(this.startCalendar, this.convention));
        MonthEndReferenceOffsetTest.assertEquals((String)target, (String)adjusted);
    }

    public void test1M() {
        String target = "2006/10/31";
        String adjusted = ISDADateFormat.format(this.wend.advance(this.startCalendar, 1, 2, this.convention));
        MonthEndReferenceOffsetTest.assertEquals((String)target, (String)adjusted);
    }

    public void test2M() {
        String target = "2006/11/30";
        String adjusted = ISDADateFormat.format(this.wend.advance(this.startCalendar, 2, 2, this.convention));
        MonthEndReferenceOffsetTest.assertEquals((String)target, (String)adjusted);
    }

    public void test3M() {
        String target = "2006/12/29";
        String adjusted = ISDADateFormat.format(this.wend.advance(this.startCalendar, 3, 2, this.convention));
        MonthEndReferenceOffsetTest.assertEquals((String)target, (String)adjusted);
    }

    public void test6M() {
        String target = "2007/3/30";
        String adjusted = ISDADateFormat.format(this.wend.advance(this.startCalendar, 6, 2, this.convention));
        MonthEndReferenceOffsetTest.assertEquals((String)target, (String)adjusted);
    }

    public void test9M() {
        String target = "2007/6/29";
        String adjusted = ISDADateFormat.format(this.wend.advance(this.startCalendar, 9, 2, this.convention));
        MonthEndReferenceOffsetTest.assertEquals((String)target, (String)adjusted);
    }
}

