/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday.defaultimpl;

import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarException;
import org.jfin.date.holiday.HolidayCalendarFactory;

public class DateAdvanceTest
extends TestCase {
    public void testDaysBackwards() {
        this.advance(new GregorianCalendar(2006, 1, 10), -5, 6, new GregorianCalendar(2006, 1, 3));
    }

    public void testDaysForwards() {
        this.advance(new GregorianCalendar(2006, 1, 10), 5, 6, new GregorianCalendar(2006, 1, 17));
    }

    public void testBadAdvance() {
        try {
            this.advance(new GregorianCalendar(2005, 0, 10), 5, -1000, new GregorianCalendar(2005, 0, 15));
        }
        catch (HolidayCalendarException e) {
            return;
        }
        DateAdvanceTest.fail((String)"Advance did not throw an exception even given an improper Calendar unit.");
    }

    public void advance(Calendar referenceCalendar, int amount, int unit, Calendar targetCalendar) {
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        HolidayCalendar wend = holidayCalendarFactory.getHolidayCalendar("WE");
        BusinessDayConvention unadjusted = BusinessDayConvention.UNADJUSTED;
        Calendar backTest = wend.advance(referenceCalendar, amount, unit, unadjusted);
        DateAdvanceTest.assertEquals((Object)backTest, (Object)targetCalendar);
    }
}

