/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.holiday.defaultimpl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import junit.framework.TestCase;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Period;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.util.ISDADateFormat;

public class DateAdjustmentTest
extends TestCase {
    private String rootPath = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.rootPath = "../target/test/data/adjustment/";
        File f = new File(this.rootPath);
        if (!f.exists()) {
            this.rootPath = "src/test/data/adjustment/";
        }
    }

    public void testFollowing() {
        this.executeTest(this.rootPath + "FOLLOWING.txt", BusinessDayConvention.FOLLOWING);
    }

    public void testModFollowing() {
        this.executeTest(this.rootPath + "modfollowing.txt", BusinessDayConvention.MODIFIED_FOLLOWING);
    }

    public void testPreceeding() {
        this.executeTest(this.rootPath + "preceeding.txt", BusinessDayConvention.PRECEDING);
    }

    public void testModPreceeding() {
        this.executeTest(this.rootPath + "modpreceeding.txt", BusinessDayConvention.MODIFIED_PRECEDING);
    }

    public void testMonthEndReference() {
        this.executeTest(this.rootPath + "monthend.txt", BusinessDayConvention.MONTH_END_REFERENCE);
    }

    public void executeTest(String fileName, BusinessDayConvention convention) {
        HolidayCalendarFactory holidayCalendarFactory = HolidayCalendarFactory.newInstance();
        HolidayCalendar wend = holidayCalendarFactory.getHolidayCalendar("WE");
        File f = new File(fileName);
        try {
            FileReader fread = new FileReader(fileName);
            BufferedReader in = new BufferedReader(fread);
            String line = null;
            Period testPeriod = new Period();
            Period testAdjustedPeriod = new Period();
            while ((line = in.readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                String[] dates = line.split("\t");
                Calendar start = ISDADateFormat.parse(dates[0]);
                Calendar target = ISDADateFormat.parse(dates[1]);
                Calendar adjusted = wend.adjust(start, convention);
                DateAdjustmentTest.assertTrue((adjusted.get(5) == target.get(5) ? 1 : 0) != 0);
                DateAdjustmentTest.assertTrue((adjusted.get(2) == target.get(2) ? 1 : 0) != 0);
                DateAdjustmentTest.assertTrue((adjusted.get(1) == target.get(1) ? 1 : 0) != 0);
                if (testPeriod.getStartCalendar() == null) {
                    testPeriod.setStartCalendar(start);
                    testAdjustedPeriod.setStartCalendar(target);
                    continue;
                }
                if (testPeriod.getEndCalendar() != null) {
                    testPeriod.setStartCalendar(testPeriod.getEndCalendar());
                    testAdjustedPeriod.setStartCalendar(testAdjustedPeriod.getEndCalendar());
                }
                testPeriod.setEndCalendar(start);
                testAdjustedPeriod.setEndCalendar(target);
                DateAdjustmentTest.assertTrue((wend.adjust(testPeriod, convention).compareTo(testAdjustedPeriod) == 0 ? 1 : 0) != 0);
            }
            in.close();
            fread.close();
        }
        catch (Exception e) {
            DateAdjustmentTest.fail((String)(f.getAbsolutePath() + " " + e.getMessage()));
        }
    }
}

