/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test.accrual;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.jfin.common.Iso4217Currency;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Period;
import org.jfin.date.accrual.AccrualException;
import org.jfin.date.accrual.AccrualSchedule;
import org.jfin.date.accrual.Payment;
import org.jfin.date.accrual.PaymentType;
import org.jfin.date.accrual.impl.FixedAccrualPeriod;
import org.jfin.date.accrual.impl.FlatNotionalSchedule;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountCalculatorFactory;
import org.jfin.date.util.ISDADateFormat;

public class AccrualScheduleTest
extends TestCase {
    public void testNetPayments() throws ParseException {
        ArrayList<Payment> payments = new ArrayList<Payment>();
        payments.add(new Payment(100.0, Iso4217Currency.EUR, ISDADateFormat.parse("2006/01/01")));
        payments.add(new Payment(150.0, Iso4217Currency.EUR, ISDADateFormat.parse("2006/01/01")));
        payments.add(new Payment(200.0, Iso4217Currency.EUR, ISDADateFormat.parse("2006/01/02")));
        payments.add(new Payment(300.0, Iso4217Currency.GBP, ISDADateFormat.parse("2006/01/02")));
        AccrualSchedule accrualSchedule = new AccrualSchedule(new Payment());
        List<Payment> nettedPayments = accrualSchedule.netPayments(payments);
        AccrualScheduleTest.assertEquals((int)3, (int)nettedPayments.size());
        for (Payment payment : nettedPayments) {
            if (payment.getCurrency() == Iso4217Currency.EUR && ISDADateFormat.formatFixedLength(payment.getPaymentCalendar()).equals("2006/01/01")) {
                AccrualScheduleTest.assertEquals((Object)250.0, (Object)payment.getAmount());
                continue;
            }
            if (payment.getCurrency() == Iso4217Currency.GBP) {
                AccrualScheduleTest.assertEquals((Object)300.0, (Object)payment.getAmount());
                continue;
            }
            AccrualScheduleTest.assertEquals((Object)200.0, (Object)payment.getAmount());
        }
    }

    public void testGetPayments() throws Exception {
        AccrualSchedule<FixedAccrualPeriod, Payment> accrualSchedule = new AccrualSchedule<FixedAccrualPeriod, Payment>(new Payment());
        DaycountCalculator daycountCalculator = DaycountCalculatorFactory.newInstance().getEU30360();
        FixedAccrualPeriod accrualPeriod = new FixedAccrualPeriod();
        accrualPeriod.setStartCalendar(ISDADateFormat.parse("2006/01/01"));
        accrualPeriod.setEndCalendar(ISDADateFormat.parse("2006/04/01"));
        accrualPeriod.setPaymentType(PaymentType.IN_ADVANCE);
        accrualPeriod.setPaymentBusinessDayConvention(BusinessDayConvention.UNADJUSTED);
        accrualPeriod.setAccrualBusinessDayConvention(BusinessDayConvention.UNADJUSTED);
        accrualPeriod.setDaycountCalculator(daycountCalculator);
        accrualPeriod.setFixedRate(0.1);
        accrualPeriod.initialise();
        accrualSchedule.add(accrualPeriod);
        FlatNotionalSchedule notionalSchedule = new FlatNotionalSchedule(100.0, Iso4217Currency.EUR);
        List<Payment> payments = accrualSchedule.getPayments(notionalSchedule);
        AccrualScheduleTest.assertEquals((int)1, (int)payments.size());
        Payment payment = payments.get(0);
        AccrualScheduleTest.assertTrue((payment.getAmount() > 2.3 ? 1 : 0) != 0);
        AccrualScheduleTest.assertTrue((payment.getAmount() < 2.7 ? 1 : 0) != 0);
        AccrualScheduleTest.assertEquals((Object)((Object)Iso4217Currency.EUR), (Object)((Object)payment.getCurrency()));
        AccrualScheduleTest.assertEquals((String)"2006/01/01", (String)ISDADateFormat.formatFixedLength(payment.getPaymentCalendar()));
    }

    public void testGetStartCalendar1() {
        AccrualSchedule accrualSchedule = new AccrualSchedule(new Payment());
        try {
            accrualSchedule.getStartCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        AccrualScheduleTest.fail((String)"Exception not thrown when getting start calendar from an empty accrual schedule");
    }

    public void testGetEndCalendar1() {
        AccrualSchedule accrualSchedule = new AccrualSchedule(new Payment());
        try {
            accrualSchedule.getEndCalendar();
        }
        catch (AccrualException e) {
            return;
        }
        AccrualScheduleTest.fail((String)"Exception not thrown when getting end calendar from an empty accrual schedule");
    }

    public void testGetStartEndCalendar1() throws ParseException, AccrualException {
        AccrualSchedule<FixedAccrualPeriod, Payment> accrualSchedule = new AccrualSchedule<FixedAccrualPeriod, Payment>(new Payment());
        accrualSchedule.add(new FixedAccrualPeriod(new Period(ISDADateFormat.parse("2006/1/1"), ISDADateFormat.parse("2006/4/3"))));
        AccrualScheduleTest.assertEquals((String)"2006/01/01", (String)ISDADateFormat.formatFixedLength(accrualSchedule.getStartCalendar()));
        AccrualScheduleTest.assertEquals((String)"2006/04/03", (String)ISDADateFormat.formatFixedLength(accrualSchedule.getEndCalendar()));
    }

    public void testGetStartEndCalendar2() throws ParseException, AccrualException {
        AccrualSchedule<FixedAccrualPeriod, Payment> accrualSchedule = new AccrualSchedule<FixedAccrualPeriod, Payment>(new Payment());
        accrualSchedule.add(new FixedAccrualPeriod(new Period(ISDADateFormat.parse("2006/1/1"), ISDADateFormat.parse("2006/4/3"))));
        accrualSchedule.add(new FixedAccrualPeriod(new Period(ISDADateFormat.parse("2006/4/3"), ISDADateFormat.parse("2006/7/1"))));
        AccrualScheduleTest.assertEquals((String)"2006/01/01", (String)ISDADateFormat.formatFixedLength(accrualSchedule.getStartCalendar()));
        AccrualScheduleTest.assertEquals((String)"2006/07/01", (String)ISDADateFormat.formatFixedLength(accrualSchedule.getEndCalendar()));
    }

    public void testSize1() {
        AccrualSchedule accrualSchedule = new AccrualSchedule(new Payment());
        AccrualScheduleTest.assertEquals((int)0, (int)accrualSchedule.size());
        AccrualScheduleTest.assertEquals((int)0, (int)accrualSchedule.getAccrualPeriods().size());
        AccrualScheduleTest.assertTrue((boolean)accrualSchedule.isEmpty());
        AccrualScheduleTest.assertFalse((boolean)accrualSchedule.iterator().hasNext());
    }

    public void testSize2() throws ParseException {
        AccrualSchedule<FixedAccrualPeriod, Payment> accrualSchedule = new AccrualSchedule<FixedAccrualPeriod, Payment>(new Payment());
        accrualSchedule.add(new FixedAccrualPeriod(new Period(ISDADateFormat.parse("2006/1/1"), ISDADateFormat.parse("2006/4/3"))));
        AccrualScheduleTest.assertEquals((int)1, (int)accrualSchedule.size());
        AccrualScheduleTest.assertEquals((int)1, (int)accrualSchedule.getAccrualPeriods().size());
        AccrualScheduleTest.assertFalse((boolean)accrualSchedule.isEmpty());
        AccrualScheduleTest.assertTrue((boolean)accrualSchedule.iterator().hasNext());
    }

    public void testContains1() throws ParseException {
        AccrualSchedule accrualSchedule = new AccrualSchedule(new Payment());
        FixedAccrualPeriod period = new FixedAccrualPeriod(new Period(ISDADateFormat.parse("2006/1/1"), ISDADateFormat.parse("2006/4/3")));
        AccrualScheduleTest.assertFalse((boolean)accrualSchedule.contains(period));
    }

    public void testContains2() throws ParseException {
        AccrualSchedule<FixedAccrualPeriod, Payment> accrualSchedule = new AccrualSchedule<FixedAccrualPeriod, Payment>(new Payment());
        FixedAccrualPeriod period = new FixedAccrualPeriod(new Period(ISDADateFormat.parse("2006/1/1"), ISDADateFormat.parse("2006/4/3")));
        accrualSchedule.add(period);
        AccrualScheduleTest.assertTrue((boolean)accrualSchedule.contains(period));
    }
}

