/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.test;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import junit.framework.TestCase;
import org.jfin.date.Frequency;
import org.jfin.date.Period;
import org.jfin.date.ScheduleException;
import org.jfin.date.StubType;
import org.jfin.date.Tenor;
import org.jfin.date.TypedScheduleGenerator;
import org.jfin.date.util.ISDADateFormat;

public class ScheduleGenerator2Test
extends TestCase {
    private TypedScheduleGenerator scheduleGenerator2;
    private TypedScheduleGenerator scheduleGenerator2Max;

    protected void setUp() throws Exception {
        this.scheduleGenerator2 = new TypedScheduleGenerator<Period>(new Period());
        this.scheduleGenerator2Max = new TypedScheduleGenerator<Period>(new Period(), 4);
    }

    public void testLongFirst() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_FIRST;
        ScheduleGenerator2Test.assertEquals((int)5, (int)this.scheduleGenerator2.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testLongLast() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_LAST;
        ScheduleGenerator2Test.assertEquals((int)5, (int)this.scheduleGenerator2.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testShortFirst() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_FIRST;
        ScheduleGenerator2Test.assertEquals((int)5, (int)this.scheduleGenerator2.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testShortLast() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_LAST;
        ScheduleGenerator2Test.assertEquals((int)5, (int)this.scheduleGenerator2.generateSchedule(effectiveDate, maturityDate, frequency, stubType).size());
    }

    public void testExceedMaxPeriodsStubTypeShortLast() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_LAST;
        try {
            this.scheduleGenerator2Max.generateSchedule(effectiveDate, maturityDate, frequency, stubType);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGenerator2Test.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testExceedMaxPeriodsStubTypeShortFirst() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.SHORT_FIRST;
        try {
            this.scheduleGenerator2Max.generateSchedule(effectiveDate, maturityDate, frequency, stubType);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGenerator2Test.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testExceedMaxPeriodsStubTypeLongLast() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_LAST;
        try {
            this.scheduleGenerator2Max.generateSchedule(effectiveDate, maturityDate, frequency, stubType);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGenerator2Test.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testExceedMaxPeriodsStubTypeLongFirst() throws ParseException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Calendar maturityDate = ISDADateFormat.parse("2011/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.LONG_FIRST;
        try {
            this.scheduleGenerator2Max.generateSchedule(effectiveDate, maturityDate, frequency, stubType);
        }
        catch (ScheduleException e) {
            return;
        }
        ScheduleGenerator2Test.fail((String)"Schedule generator should have thrown an exception producing a schedule with 5 periods when maxPeriods was set to 4.");
    }

    public void testScheduleWithMaturityString() throws ParseException, ScheduleException {
        Calendar effectiveDate = ISDADateFormat.parse("2006/3/28");
        Frequency frequency = Frequency.ANNUALLY;
        StubType stubType = StubType.NONE;
        String maturity = "5Y";
        ScheduleGenerator2Test.assertEquals((int)5, (int)this.scheduleGenerator2.generateSchedule(effectiveDate, maturity, frequency, stubType).size());
    }

    public void testMonthlySchedule() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/3/31");
        Calendar endDate = ISDADateFormat.parse("2012/3/31");
        List schedule = this.scheduleGenerator2.generateSchedule(startDate, endDate, Frequency.MONTHLY, StubType.SHORT_LAST);
        for (Period period : schedule) {
            Calendar periodEndDate = period.getEndCalendar();
            ScheduleGenerator2Test.assertTrue((String)("End date " + ISDADateFormat.format(periodEndDate) + " should be the end of the month."), (periodEndDate.get(5) == periodEndDate.getActualMaximum(5) ? 1 : 0) != 0);
        }
    }

    public void testTenorScheduleGeneration() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/1/1");
        Tenor tenor = new Tenor("2Y");
        List periods = this.scheduleGenerator2.generateSchedule(startDate, tenor, Frequency.QUARTERLY, StubType.NONE);
        ScheduleGenerator2Test.assertEquals((int)8, (int)periods.size());
    }

    public void testCustomFrequency() throws ParseException, ScheduleException {
        Calendar startDate = ISDADateFormat.parse("2006/1/1");
        Calendar endDate = ISDADateFormat.parse("2007/1/1");
        List periods = this.scheduleGenerator2.generateSchedule(startDate, endDate, 2, 2, StubType.NONE);
        ScheduleGenerator2Test.assertEquals((int)6, (int)periods.size());
    }
}

