/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday.financialcalendarimpl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jfin.date.holiday.financialcalendarimpl.InfoFile;
import org.jfin.date.holiday.financialcalendarimpl.InfoFileEntry;

public class HolidayFileEntry {
    private String date;
    private InfoFileEntry info;
    private String description;
    private DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    public HolidayFileEntry() {
    }

    public HolidayFileEntry(String lineToParse, InfoFile infoFile) {
        this();
        this.parse(lineToParse, infoFile);
    }

    public HolidayFileEntry(String date, InfoFileEntry info, String description) {
        this();
        this.date = date;
        this.info = info;
        this.description = description;
    }

    public void parse(String line, InfoFile infoFile) {
        String[] parts = line.split(",");
        if (parts.length > 0) {
            this.setDate(parts[0]);
        }
        if (parts.length > 1) {
            this.setInfo(infoFile.getEntryByCode(parts[1]));
        }
        if (parts.length > 2) {
            this.setDescription(parts[2]);
        }
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InfoFileEntry getInfo() {
        return this.info;
    }

    public void setInfo(InfoFileEntry info) {
        this.info = info;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public static String getReference(String date, String infoCode) {
        return date + ":" + infoCode;
    }

    public String getReference() {
        return HolidayFileEntry.getReference(this.getDate(), this.getInfo().getCode());
    }
}

