/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday.financialcalendarimpl;

import java.io.File;
import java.io.IOException;
import org.jfin.date.Period;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarException;
import org.jfin.date.holiday.HolidayCalendarFactory;
import org.jfin.date.holiday.financialcalendarimpl.FinancialCalendarHolidayCalendar;
import org.jfin.date.holiday.financialcalendarimpl.HolidayFile;
import org.jfin.date.holiday.financialcalendarimpl.InfoFile;

public class HolidayCalendarFactoryFinancialCalendarImpl
extends HolidayCalendarFactory {
    HolidayFile holidayFile;
    InfoFile infoFile;
    public static String holidayCalendarHolidayFileParameter = "jfin.FinancialCalendar.HolidayFilePath";
    public static String holidayCalendarInfoFileParameter = "jfin.FinancialCalendar.InfoFilePath";

    public HolidayCalendarFactoryFinancialCalendarImpl() {
        String holidayFilePath = System.getProperty("jfin.FinancialCalendar.HolidayFilePath");
        String infoFilePath = System.getProperty("jfin.FinancialCalendar.InfoFilePath");
        if (holidayFilePath == null) {
            throw new HolidayCalendarException("System property jfin.FinancialCalendar.HolidayFilePath not set, cannot load HolidayCalendarFactoryFinancialCalendarImpl.");
        }
        if (infoFilePath == null) {
            throw new HolidayCalendarException("System property jfin.FinancialCalendar.InfoFilePath not set, cannot load HolidayCalendarFactoryFinancialCalendarImpl.");
        }
        try {
            this.infoFile = new InfoFile(new File(infoFilePath));
            this.holidayFile = new HolidayFile(new File(holidayFilePath), this.infoFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HolidayCalendarException("IOException reading info file and holiday file, cannot load HolidayCalendarFactoryFinancialCalendarImpl.", e);
        }
    }

    @Override
    public HolidayCalendar getHolidayCalendar(String locale) {
        return this.getHolidayCalendar(locale, Period.class);
    }

    @Override
    public <T extends Period> HolidayCalendar<T> getHolidayCalendar(String locale, Class<T> c) {
        if (this.infoFile.getEntryByCode(locale) == null) {
            throw new HolidayCalendarException("Unknown locale \"" + locale + "\"");
        }
        return new FinancialCalendarHolidayCalendar(this.holidayFile, locale);
    }

    public HolidayFile getHolidayFile() {
        return this.holidayFile;
    }

    public void setHolidayFile(HolidayFile holidayFile) {
        this.holidayFile = holidayFile;
    }

    public InfoFile getInfoFile() {
        return this.infoFile;
    }

    public void setInfoFile(InfoFile infoFile) {
        this.infoFile = infoFile;
    }

    @Override
    public String[] getAvailableLocales() {
        return this.infoFile.getAvailableCodes();
    }
}

