/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday.financialcalendarimpl;

import java.util.Calendar;
import java.util.logging.Logger;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.financialcalendarimpl.HolidayFile;
import org.jfin.date.holiday.financialcalendarimpl.HolidayFileEntry;
import org.jfin.date.util.ISDADateFormat;

public class FinancialCalendarHolidayCalendar<T>
extends HolidayCalendar {
    private HolidayFile holidayFile;
    private String locale;
    private static Logger logger = Logger.getLogger("org.jfin.date.holiday.financialcalendarimpl.FinancialCalendarHolidayCalendar");

    public FinancialCalendarHolidayCalendar(HolidayFile holidayFile, String locale) {
        this.holidayFile = holidayFile;
        this.locale = locale;
    }

    @Override
    public boolean isWeekend(Calendar d) {
        String reference = HolidayFileEntry.getReference(ISDADateFormat.formatCompact(d), this.locale);
        HolidayFileEntry entry = this.holidayFile.getEntryByReference(reference);
        if (entry == null) {
            logger.fine("Found no weekend for reference " + reference);
            return false;
        }
        if (entry.getDescription().equals("Weekend")) {
            logger.fine("Found reference " + reference + " is a weekend");
            return true;
        }
        logger.fine("Found reference " + reference + " is not a weekend, \"" + entry.getDescription() + "\"");
        return false;
    }

    @Override
    public boolean isHoliday(Calendar d) {
        String reference = HolidayFileEntry.getReference(ISDADateFormat.formatCompact(d), this.locale);
        HolidayFileEntry entry = this.holidayFile.getEntryByReference(reference);
        if (entry == null) {
            logger.fine("Found no reference " + reference);
            return false;
        }
        logger.fine("Found reference " + reference + " is a holiday, \"" + entry.getDescription() + "\"");
        return true;
    }

    public HolidayFile getHolidayFile() {
        return this.holidayFile;
    }

    public void setHolidayFile(HolidayFile holidayFile) {
        this.holidayFile = holidayFile;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

