/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.holiday;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Period;
import org.jfin.date.holiday.HolidayCalendarException;

public abstract class HolidayCalendar<T extends Period> {
    private static Logger logger = Logger.getLogger("org.jfin.date.holiday.HolidayCalendar");

    public abstract boolean isWeekend(Calendar var1);

    public abstract boolean isHoliday(Calendar var1);

    public Calendar advanceBusinessDays(Calendar calendar, int offsetAmount) throws HolidayCalendarException {
        return this.advance(calendar, offsetAmount, 6, BusinessDayConvention.UNADJUSTED);
    }

    public Calendar advance(Calendar calendar, int offsetAmount, int offsetUnit, BusinessDayConvention businessDayConvention) throws HolidayCalendarException {
        if (offsetAmount == 0) {
            return this.adjust(calendar, businessDayConvention);
        }
        if (offsetUnit == 5 || offsetUnit == 5 || offsetUnit == 6) {
            Calendar d1 = (Calendar)calendar.clone();
            if (offsetAmount > 0) {
                while (offsetAmount > 0) {
                    d1.add(5, 1);
                    while (this.isHoliday(d1) || this.isWeekend(d1)) {
                        d1.add(5, 1);
                    }
                    --offsetAmount;
                }
            } else {
                while (offsetAmount < 0) {
                    d1.add(5, -1);
                    while (this.isHoliday(d1) || this.isWeekend(d1)) {
                        d1.add(5, -1);
                    }
                    ++offsetAmount;
                }
            }
            return d1;
        }
        if (offsetUnit == 2) {
            Calendar d1 = (Calendar)calendar.clone();
            d1.add(2, offsetAmount);
            return this.adjust(d1, businessDayConvention, calendar);
        }
        if (offsetUnit == 1) {
            Calendar d1 = (Calendar)calendar.clone();
            d1.add(1, offsetAmount);
            return this.adjust(d1, businessDayConvention, calendar);
        }
        throw new HolidayCalendarException("Unknown time period");
    }

    public List<T> adjust(List<T> periods, BusinessDayConvention businessDayConvention) throws HolidayCalendarException {
        ArrayList<Period> returnPeriods = new ArrayList<Period>();
        for (Period period : periods) {
            returnPeriods.add(this.adjust(period, businessDayConvention));
        }
        return returnPeriods;
    }

    public T adjust(T period, BusinessDayConvention businessDayConvention) throws HolidayCalendarException {
        logger.fine("Adjusting financial period " + (Object)((Object)businessDayConvention) + " by " + this);
        Period adjustedPeriod = ((Period)period).clone();
        adjustedPeriod.setStartCalendar(this.adjust(((Period)period).getStartCalendar(), businessDayConvention));
        adjustedPeriod.setEndCalendar(this.adjust(((Period)period).getEndCalendar(), businessDayConvention));
        return (T)adjustedPeriod;
    }

    public Calendar adjust(Calendar calendar, BusinessDayConvention businessDayConvention) throws HolidayCalendarException {
        logger.fine("Adjusting date " + calendar + " by " + (Object)((Object)businessDayConvention) + " by " + this);
        return this.adjust(calendar, businessDayConvention, null);
    }

    private Calendar adjust(Calendar calendar, BusinessDayConvention businessDayConvention, Calendar originalCalendar) throws HolidayCalendarException {
        logger.finer("Business Day Convention " + (Object)((Object)businessDayConvention));
        if (businessDayConvention == BusinessDayConvention.UNADJUSTED) {
            logger.finer("Business Day Convention \"Unadjusted\" returning original date.");
            return calendar;
        }
        Calendar d1 = (Calendar)calendar.clone();
        if (businessDayConvention == BusinessDayConvention.FOLLOWING || businessDayConvention == BusinessDayConvention.MODIFIED_FOLLOWING) {
            while (this.isHoliday(d1) || this.isWeekend(d1)) {
                logger.finest(d1 + " is a holiday in " + this + " stepping forward.");
                d1.add(5, 1);
            }
            if (businessDayConvention == BusinessDayConvention.MODIFIED_FOLLOWING && d1.get(2) != calendar.get(2)) {
                logger.finer(d1 + " moved over month boundary, so have to take previous date from " + calendar);
                return this.adjust(calendar, BusinessDayConvention.PRECEDING);
            }
        } else if (businessDayConvention == BusinessDayConvention.PRECEDING || businessDayConvention == BusinessDayConvention.MODIFIED_PRECEDING) {
            while (this.isHoliday(d1) || this.isWeekend(d1)) {
                logger.finest(d1 + " is a holiday in " + this + " stepping backward.");
                d1.add(5, -1);
            }
            if (businessDayConvention == BusinessDayConvention.MODIFIED_PRECEDING && d1.get(2) != calendar.get(2)) {
                logger.finer(d1 + " moved over month boundary, so have to take FOLLOWING date from " + calendar);
                return this.adjust(calendar, BusinessDayConvention.FOLLOWING);
            }
        } else {
            if (businessDayConvention == BusinessDayConvention.MONTH_END_REFERENCE) {
                d1 = (Calendar)calendar.clone();
                HolidayCalendar.setToEndOfMonth(d1);
                logger.finest("Date moved to " + d1);
                logger.finer("Finding last business day in month for " + d1);
                return this.adjust(d1, BusinessDayConvention.PRECEDING);
            }
            throw new HolidayCalendarException("Unknown business-day convention");
        }
        logger.finer("Returning calculated date " + d1);
        return d1;
    }

    public static boolean isLastDayOfMonth(Calendar calendar) {
        return calendar.get(5) == calendar.getActualMaximum(5);
    }

    public static Calendar setToEndOfMonth(Calendar calendar) {
        calendar.set(5, HolidayCalendar.getDaysInMonth(calendar));
        return calendar;
    }

    public static int getDaysInMonth(Calendar calendar) {
        return calendar.getActualMaximum(5);
    }

    public long getBusinessDaysBetween(Calendar startCalendar, Calendar endCalendar) throws HolidayCalendarException {
        Calendar holdCalendar = (Calendar)startCalendar.clone();
        long businessDays = 0L;
        try {
            while (holdCalendar.before(endCalendar)) {
                holdCalendar = this.advanceBusinessDays(holdCalendar, 1);
                ++businessDays;
            }
            return businessDays;
        }
        catch (HolidayCalendarException e) {
            throw new HolidayCalendarException(e);
        }
    }
}

