/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import java.util.Calendar;
import java.util.logging.Logger;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;

public class IT30360
extends DaycountCalculator {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.defaultimpl.IT30360");

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar) throws DaycountException {
        if (startCalendar.after(endCalendar)) {
            logger.fine("Dates are wrong way round so swap over");
            Calendar holdCalendar = startCalendar;
            startCalendar = endCalendar;
            endCalendar = holdCalendar;
        }
        if (startCalendar.equals(endCalendar)) {
            logger.fine("Dates are the same so return zero");
            return 0.0;
        }
        int dd1 = startCalendar.get(5);
        int dd2 = endCalendar.get(5);
        int mm1 = startCalendar.get(2);
        int mm2 = endCalendar.get(2);
        int yy1 = startCalendar.get(1);
        int yy2 = endCalendar.get(1);
        if (mm1 == 2 && dd1 > 27) {
            dd1 = 30;
        }
        if (mm2 == 2 && dd2 > 27) {
            dd2 = 30;
        }
        return (double)(yy2 - yy1) + (double)(30 * (mm2 - mm1 - 1) + Math.max(0, 30 - dd1) + Math.min(30, dd2)) / 360.0;
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar, Calendar periodStartCalendar, Calendar periodEndCalendar) throws DaycountException {
        return this.calculateDaycountFraction(startCalendar, endCalendar);
    }
}

