/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import java.util.Calendar;
import java.util.logging.Logger;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;
import org.jfin.date.holiday.HolidayCalendar;
import org.jfin.date.holiday.HolidayCalendarException;

public class Business252
extends DaycountCalculator {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.defaultimpl.Business252");
    private HolidayCalendar holidayCalendar = null;

    public Business252(HolidayCalendar holidayCalendar) {
        this.holidayCalendar = holidayCalendar;
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar) throws DaycountException {
        if (startCalendar.after(endCalendar)) {
            logger.fine("Dates are wrong way round so swap over");
            Calendar holdCalendar = startCalendar;
            startCalendar = endCalendar;
            endCalendar = holdCalendar;
        }
        if (startCalendar.equals(endCalendar)) {
            logger.fine("Dates are the same so return zero");
            return 0.0;
        }
        try {
            long businessDays = this.holidayCalendar.getBusinessDaysBetween(startCalendar, endCalendar);
            return (double)businessDays / 252.0;
        }
        catch (HolidayCalendarException e) {
            throw new DaycountException(e);
        }
    }

    public HolidayCalendar getHolidayCalendar() {
        return this.holidayCalendar;
    }

    public void setHolidayCalendar(HolidayCalendar holidayCalendar) {
        this.holidayCalendar = holidayCalendar;
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar, Calendar periodStartCalendar, Calendar periodEndCalendar) throws DaycountException {
        return this.calculateDaycountFraction(startCalendar, endCalendar);
    }
}

