/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.daycount.defaultimpl;

import java.util.Calendar;
import java.util.logging.Logger;
import org.jfin.date.daycount.DaycountCalculator;
import org.jfin.date.daycount.DaycountException;

public class Actual360
extends DaycountCalculator {
    private static Logger logger = Logger.getLogger("org.jfin.date.daycount.defaultimpl.Actual360");

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar) throws DaycountException {
        if (startCalendar.after(endCalendar)) {
            logger.fine("Dates are wrong way round so swap over");
            Calendar holdCalendar = startCalendar;
            startCalendar = endCalendar;
            endCalendar = holdCalendar;
        }
        if (startCalendar.equals(endCalendar)) {
            logger.fine("Dates are the same so return zero");
            return 0.0;
        }
        return (double)this.daysBetween(startCalendar, endCalendar) / 360.0;
    }

    @Override
    public double calculateDaycountFraction(Calendar startCalendar, Calendar endCalendar, Calendar periodStartCalendar, Calendar periodEndCalendar) throws DaycountException {
        return this.calculateDaycountFraction(startCalendar, endCalendar);
    }
}

