/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.accrual.impl;

import java.util.Calendar;
import org.jfin.date.BusinessDayConvention;
import org.jfin.date.Period;
import org.jfin.date.accrual.AccrualException;
import org.jfin.date.accrual.AccrualPeriod;
import org.jfin.date.accrual.impl.FixingAdjustmentType;
import org.jfin.date.holiday.HolidayCalendar;

public class FloatAccrualPeriod
extends AccrualPeriod {
    private Calendar fixingCalendar;
    private BusinessDayConvention fixingBusinessDayConvention;
    private HolidayCalendar fixingHolidayCalendar;
    private int fixingCalendarOffsetDays;
    private double fixingRate = Double.NaN;
    private FixingAdjustmentType fixingAdjustmentType;

    public FloatAccrualPeriod() {
    }

    protected FloatAccrualPeriod(Period toCopy) {
        super(toCopy);
        if (toCopy instanceof FloatAccrualPeriod) {
            FloatAccrualPeriod floatAccrualPeriodToCopy = (FloatAccrualPeriod)toCopy;
            this.fixingCalendar = floatAccrualPeriodToCopy.fixingCalendar;
            this.fixingBusinessDayConvention = floatAccrualPeriodToCopy.fixingBusinessDayConvention;
            this.fixingHolidayCalendar = floatAccrualPeriodToCopy.fixingHolidayCalendar;
            this.fixingCalendarOffsetDays = floatAccrualPeriodToCopy.fixingCalendarOffsetDays;
            this.fixingRate = floatAccrualPeriodToCopy.fixingRate;
            this.fixingAdjustmentType = floatAccrualPeriodToCopy.fixingAdjustmentType;
        }
    }

    @Override
    public FloatAccrualPeriod clone() {
        return new FloatAccrualPeriod(this);
    }

    @Override
    public void initialise() {
        super.initialise();
        if (this.fixingHolidayCalendar != null && this.getPaymentCalendar() != null && this.fixingAdjustmentType != null) {
            this.fixingCalendar = this.fixingAdjustmentType == FixingAdjustmentType.BUSINESS_DAYS ? this.fixingHolidayCalendar.advanceBusinessDays(this.getPaymentCalendar(), this.fixingCalendarOffsetDays) : this.fixingHolidayCalendar.advance(this.getPaymentCalendar(), this.fixingCalendarOffsetDays, 5, BusinessDayConvention.UNADJUSTED);
        }
    }

    @Override
    public double getPaymentAmount(double notional) throws Exception {
        if (Double.isNaN(this.fixingRate)) {
            throw new AccrualException("Attempt to get payment amount for a FloatAccrualPeriod where the fixingRate has not been fixed.");
        }
        return this.getAdjustedDaycountFraction() * this.getFixingRate() * notional;
    }

    @Override
    public boolean isPaymentPossible() {
        return !Double.isNaN(this.getFixingRate());
    }

    public Calendar getAdjustedFixingCalendar() throws AccrualException {
        if (this.fixingCalendar == null) {
            throw new AccrualException("Could not get adjusted fixing calendar where the fixing calendar is null.");
        }
        if (this.fixingBusinessDayConvention == null) {
            throw new AccrualException("Could not get adjusted fixing calendar where the fixing business day convention is null.");
        }
        if (this.fixingHolidayCalendar == null) {
            throw new AccrualException("Could not get adjusted fixing calendar where the fixing holiday calendar is null.");
        }
        return this.fixingHolidayCalendar.adjust(this.fixingCalendar, this.fixingBusinessDayConvention);
    }

    public Calendar getFixingCalendar() {
        return this.fixingCalendar;
    }

    public void setFixingCalendar(Calendar fixingCalendar) {
        this.fixingCalendar = fixingCalendar;
    }

    public FixingAdjustmentType getFixingAdjustmentType() {
        return this.fixingAdjustmentType;
    }

    public void setFixingAdjustmentType(FixingAdjustmentType fixingAdjustmentType) {
        this.fixingAdjustmentType = fixingAdjustmentType;
    }

    public BusinessDayConvention getFixingBusinessDayConvention() {
        return this.fixingBusinessDayConvention;
    }

    public void setFixingBusinessDayConvention(BusinessDayConvention fixingBusinessDayConvention) {
        this.fixingBusinessDayConvention = fixingBusinessDayConvention;
    }

    public HolidayCalendar getFixingHolidayCalendar() {
        return this.fixingHolidayCalendar;
    }

    public void setFixingHolidayCalendar(HolidayCalendar fixingHolidayCalendar) {
        this.fixingHolidayCalendar = fixingHolidayCalendar;
    }

    public int getFixingCalendarOffsetAmount() {
        return this.fixingCalendarOffsetDays;
    }

    public void setFixingCalendarOffsetAmount(int fixingCalendarOffsetAmount) {
        this.fixingCalendarOffsetDays = fixingCalendarOffsetAmount;
    }

    public double getFixingRate() {
        return this.fixingRate;
    }

    public void setFixingRate(double fixingRate) {
        this.fixingRate = fixingRate;
    }
}

