/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.accrual.impl;

import org.jfin.date.Period;
import org.jfin.date.accrual.AccrualPeriod;

public class FixedAccrualPeriod
extends AccrualPeriod {
    private double fixedRate;

    public FixedAccrualPeriod() {
    }

    public FixedAccrualPeriod(Period toCopy) {
        super(toCopy);
        if (toCopy instanceof FixedAccrualPeriod) {
            FixedAccrualPeriod fixedAccrualPeriodToCopy = (FixedAccrualPeriod)toCopy;
            this.fixedRate = fixedAccrualPeriodToCopy.fixedRate;
        }
    }

    @Override
    public FixedAccrualPeriod clone() {
        return new FixedAccrualPeriod(this);
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public void setFixedRate(double fixedRate) {
        this.fixedRate = fixedRate;
    }

    @Override
    public double getPaymentAmount(double notional) throws Exception {
        return this.getAdjustedDaycountFraction() * this.fixedRate * notional;
    }

    @Override
    public boolean isPaymentPossible() {
        return true;
    }
}

