/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date.accrual;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jfin.date.ScheduleCutter;
import org.jfin.date.accrual.AccrualException;
import org.jfin.date.accrual.AccrualPeriod;
import org.jfin.date.accrual.NotionalPeriod;
import org.jfin.date.accrual.NotionalSchedule;
import org.jfin.date.accrual.Payment;

public class AccrualSchedule<T extends AccrualPeriod, U extends Payment> {
    private List<T> accrualPeriods;
    private U paymentPrototype;

    public AccrualSchedule(U paymentPrototype) {
        this.paymentPrototype = paymentPrototype;
        this.accrualPeriods = new ArrayList<T>();
    }

    public List<U> getNettedPayments(NotionalSchedule notionalSchedule) throws Exception {
        return this.netPayments(this.getPayments(notionalSchedule));
    }

    public List<U> netPayments(List<U> payments) {
        ArrayList<Payment> nettedPayments = new ArrayList<Payment>();
        for (Payment payment : payments) {
            nettedPayments.add(payment.clone());
        }
        for (int i = 0; i < nettedPayments.size() - 1; ++i) {
            for (int j = i + 1; j < nettedPayments.size(); ++j) {
                Payment paymentj;
                Payment paymenti = (Payment)nettedPayments.get(i);
                if (!paymenti.equalsIgnoringAmount(paymentj = (Payment)nettedPayments.get(j))) continue;
                paymenti.setAmount(paymenti.getAmount() + paymentj.getAmount());
                nettedPayments.remove(j);
            }
        }
        return nettedPayments;
    }

    public List<U> getPayments(NotionalSchedule notionalSchedule) throws Exception {
        ArrayList<Payment> ret = new ArrayList<Payment>();
        List<NotionalPeriod> notionalPeriods = notionalSchedule.getNotionalPeriodsBetween(this.getStartCalendar(), this.getEndCalendar());
        ScheduleCutter<T> accrualScheduleCutter = new ScheduleCutter<T>();
        ScheduleCutter<NotionalPeriod> notionalScheduleCutter = new ScheduleCutter<NotionalPeriod>();
        List cutAccrualPeriods = accrualScheduleCutter.cutSchedules(this.accrualPeriods, notionalPeriods);
        List<NotionalPeriod> cutNotionalPeriods = notionalScheduleCutter.cutSchedules(notionalPeriods, this.accrualPeriods);
        if (cutAccrualPeriods.size() != cutNotionalPeriods.size()) {
            throw new AccrualException("Error cutting accrual and notional periods, resultant sizes are different.");
        }
        Iterator cutAccrualPeriodsIterator = cutAccrualPeriods.iterator();
        Iterator<NotionalPeriod> cutNotionalPeriodsIterator = cutNotionalPeriods.iterator();
        while (cutAccrualPeriodsIterator.hasNext()) {
            AccrualPeriod accrualPeriod = (AccrualPeriod)cutAccrualPeriodsIterator.next();
            NotionalPeriod notionalPeriod = cutNotionalPeriodsIterator.next();
            if (!accrualPeriod.isPaymentPossible()) continue;
            double paymentAmount = accrualPeriod.getPaymentAmount(notionalPeriod.getAmount());
            Payment payment = ((Payment)this.paymentPrototype).clone();
            payment.setAmount(paymentAmount);
            payment.setCurrency(notionalPeriod.getCurrency());
            payment.setPaymentCalendar(accrualPeriod.getPaymentCalendar());
            ret.add(payment);
        }
        return ret;
    }

    public Calendar getStartCalendar() throws AccrualException {
        if (this.accrualPeriods.size() == 0) {
            throw new AccrualException("Attempt to get start calendar for an AccrualSchedule with no AccrualPeriods");
        }
        return ((AccrualPeriod)this.accrualPeriods.get(0)).getStartCalendar();
    }

    public Calendar getEndCalendar() throws AccrualException {
        if (this.accrualPeriods.size() == 0) {
            throw new AccrualException("Attempt to get end calendar for an AccrualSchedule with no AccrualPeriods");
        }
        return ((AccrualPeriod)this.accrualPeriods.get(this.accrualPeriods.size() - 1)).getEndCalendar();
    }

    public List<T> getAccrualPeriods() {
        return this.accrualPeriods;
    }

    public void setAccrualPeriods(List<T> accrualPeriods) {
        this.accrualPeriods = accrualPeriods;
    }

    public int size() {
        return this.accrualPeriods.size();
    }

    public boolean isEmpty() {
        return this.accrualPeriods.isEmpty();
    }

    public boolean contains(Object o) {
        return this.accrualPeriods.contains(o);
    }

    public Iterator<T> iterator() {
        return this.accrualPeriods.iterator();
    }

    public boolean add(T accrualPeriod) {
        return this.accrualPeriods.add(accrualPeriod);
    }

    public boolean remove(Object o) {
        return this.accrualPeriods.remove(o);
    }

    public boolean containsAll(Collection<?> objects) {
        return this.accrualPeriods.containsAll(objects);
    }

    public boolean addAll(Collection<? extends T> ts) {
        return this.accrualPeriods.addAll(ts);
    }

    public boolean addAll(int i, Collection<? extends T> ts) {
        return this.accrualPeriods.addAll(i, ts);
    }

    public boolean removeAll(Collection<?> objects) {
        return this.accrualPeriods.removeAll(objects);
    }

    public boolean retainAll(Collection<?> objects) {
        return this.accrualPeriods.retainAll(objects);
    }

    public void clear() {
        this.accrualPeriods.clear();
    }

    public T get(int i) {
        return (T)((AccrualPeriod)this.accrualPeriods.get(i));
    }

    public T set(int i, T t) {
        return (T)((AccrualPeriod)this.accrualPeriods.set(i, t));
    }

    public void add(int i, T t) {
        this.accrualPeriods.add(i, t);
    }

    public T remove(int i) {
        return (T)((AccrualPeriod)this.accrualPeriods.remove(i));
    }

    public int indexOf(Object o) {
        return this.accrualPeriods.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.accrualPeriods.lastIndexOf(o);
    }

    public List<T> subList(int i, int i1) {
        return this.accrualPeriods.subList(i, i1);
    }
}

