/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date;

import java.text.DecimalFormat;
import java.text.ParseException;

public class Tenor {
    private int amount;
    private int calendarUnit;
    private static String[] spotNodeSynonyms = new String[]{"SN", "S/N", "ON", "O/N"};
    private static String[] tomorrowSynonyms = new String[]{"TN", "T/N"};
    private static DecimalFormat dayFormat = new DecimalFormat("#D");
    private static DecimalFormat weekFormat = new DecimalFormat("#W");
    private static DecimalFormat monthFormat = new DecimalFormat("#M");
    private static DecimalFormat yearFormat = new DecimalFormat("#Y");

    public Tenor(String toParse) throws ParseException {
        this.parse(toParse);
    }

    public void parse(String toParse) throws ParseException {
        if (Tenor.arrayContainsString(spotNodeSynonyms, toParse)) {
            this.amount = 0;
            this.calendarUnit = 6;
            return;
        }
        if (Tenor.arrayContainsString(tomorrowSynonyms, toParse)) {
            this.amount = 1;
            this.calendarUnit = 6;
            return;
        }
        toParse = toParse.toUpperCase();
        try {
            this.amount = dayFormat.parse(toParse).intValue();
            this.calendarUnit = 6;
            return;
        }
        catch (ParseException e) {
            try {
                this.amount = weekFormat.parse(toParse).intValue();
                this.amount *= 7;
                this.calendarUnit = 6;
                return;
            }
            catch (ParseException e2) {
                try {
                    this.amount = monthFormat.parse(toParse).intValue();
                    this.calendarUnit = 2;
                    return;
                }
                catch (ParseException e3) {
                    try {
                        this.amount = yearFormat.parse(toParse).intValue();
                        this.calendarUnit = 1;
                        return;
                    }
                    catch (ParseException parseException) {
                        throw new ParseException("Could not parse tenor " + toParse, 0);
                    }
                }
            }
        }
    }

    private static boolean arrayContainsString(String[] array, String search) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(search)) continue;
            return true;
        }
        return false;
    }

    public Tenor(int amount, int calendarUnit) {
        this.setAmount(amount);
        this.setCalendarUnit(calendarUnit);
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public int getCalendarUnit() {
        return this.calendarUnit;
    }

    public void setCalendarUnit(int calendarUnit) {
        this.calendarUnit = calendarUnit;
    }
}

