/*
 * Decompiled with CFR 0.152.
 */
package org.jfin.date;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jfin.date.Period;
import org.jfin.date.ScheduleCutterPeriodComparator;
import org.jfin.date.ScheduleException;
import org.jfin.date.util.ISDADateFormat;

public class ScheduleCutter<T extends Period> {
    private static Logger logger = Logger.getLogger("org.jfin.date.ScheduleCutter");
    private static ScheduleCutterPeriodComparator scheduleCutterPeriodComparator = new ScheduleCutterPeriodComparator();

    public List<T> cutSchedules(List<T> scheduleToCut, List<? extends Period> cutTemplate) throws ScheduleException {
        ArrayList<Calendar> cutCalendars = new ArrayList<Calendar>();
        logger.finer("Creating distinct list of dates in the cut template.");
        for (Period period : cutTemplate) {
            if (!cutCalendars.contains(period.getStartCalendar())) {
                cutCalendars.add(period.getStartCalendar());
            }
            if (cutCalendars.contains(period.getEndCalendar())) continue;
            cutCalendars.add(period.getEndCalendar());
        }
        return this.cutScheduleByDates(scheduleToCut, cutCalendars);
    }

    public List<T> cutScheduleByDates(List<T> scheduleToCut, List<Calendar> cutDates) throws ScheduleException {
        logger.finer("Ensuring that the schedule to cut does not have overlapping periods.");
        Collections.sort(scheduleToCut, scheduleCutterPeriodComparator);
        for (int i = 1; i < scheduleToCut.size(); ++i) {
            Period period1 = (Period)scheduleToCut.get(i - 1);
            Period period2 = (Period)scheduleToCut.get(i);
            if (period1.getEndCalendar().compareTo(period2.getStartCalendar()) <= 0) continue;
            throw new ScheduleException("Could not cut schedule with overlapping periods (period " + (i - 1) + ": " + period1 + " and period " + i + ": " + period2);
        }
        logger.finer("Cutting schedule");
        ArrayList<Period> resultantSchedule = new ArrayList<Period>();
        for (Period period : scheduleToCut) {
            resultantSchedule.addAll(this.cutPeriodByDates(period, cutDates));
        }
        return resultantSchedule;
    }

    public List<T> cutPeriodByDates(T period, List<Calendar> cutDates) {
        ArrayList<Period> resultantSchedule = new ArrayList<Period>();
        for (Calendar date : cutDates) {
            if (!this.periodContainsDate(period, date)) continue;
            logger.finest("Cutting period " + period + " by date " + ISDADateFormat.format(date));
            Period cutPeriod1 = ((Period)period).clone();
            Period cutPeriod2 = ((Period)period).clone();
            cutPeriod1.setEndCalendar(date);
            cutPeriod2.setStartCalendar(date);
            resultantSchedule.addAll(this.cutPeriodByDates(cutPeriod1, cutDates));
            resultantSchedule.addAll(this.cutPeriodByDates(cutPeriod2, cutDates));
            return resultantSchedule;
        }
        logger.finest("Period " + period + " not cut by any of the cut dates");
        resultantSchedule.add((Period)period);
        return resultantSchedule;
    }

    public boolean periodContainsDate(T period, Calendar date) {
        return ((Period)period).getStartCalendar().before(date) && ((Period)period).getEndCalendar().after(date);
    }
}

