/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.schedule.impl;

import com.mbc.jfin.schedule.Schedule;
import com.mbc.jfin.schedule.ScheduleException;
import com.mbc.jfin.schedule.SchedulePeriod;
import com.mbc.jfin.schedule.impl.AbstractBaseScheduleGenerator;
import com.mbc.jfin.schedule.impl.ScheduleTooLongException;
import java.util.ArrayList;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePeriod;

public class ShortFirstStubScheduleGenerator
extends AbstractBaseScheduleGenerator {
    public ShortFirstStubScheduleGenerator() {
        super(-1);
    }

    public ShortFirstStubScheduleGenerator(int maxPeriods) {
        super(maxPeriods);
    }

    @Override
    public Schedule generate(LocalDate start, LocalDate end, ReadablePeriod frequency) throws ScheduleException {
        ArrayList<SchedulePeriod> schedulePeriods = new ArrayList<SchedulePeriod>();
        LocalDate holdDate = end;
        int periodCount = 1;
        while (holdDate.isAfter(start)) {
            LocalDate nextDate = end.minus(this.multiplyPeriod(frequency, periodCount));
            LocalDate notionalStartDate = null;
            LocalDate notionalEndDate = null;
            if (nextDate.isBefore(start)) {
                notionalStartDate = nextDate;
                notionalEndDate = holdDate;
                nextDate = start;
            }
            SchedulePeriod schedulePeriod = new SchedulePeriod(nextDate, holdDate, notionalStartDate, notionalEndDate);
            schedulePeriods.add(0, schedulePeriod);
            holdDate = nextDate;
            if (this.maxPeriods <= 0 || ++periodCount <= this.maxPeriods) continue;
            throw new ScheduleTooLongException(this.maxPeriods);
        }
        return new Schedule(schedulePeriods);
    }
}

