/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.schedule.impl;

import com.mbc.jfin.schedule.Schedule;
import com.mbc.jfin.schedule.ScheduleException;
import com.mbc.jfin.schedule.SchedulePeriod;
import com.mbc.jfin.schedule.impl.AbstractBaseScheduleGenerator;
import com.mbc.jfin.schedule.impl.ScheduleTooLongException;
import java.util.ArrayList;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePeriod;

public class LongLastStubScheduleGenerator
extends AbstractBaseScheduleGenerator {
    public LongLastStubScheduleGenerator() {
        super(-1);
    }

    public LongLastStubScheduleGenerator(int maxPeriods) {
        super(maxPeriods);
    }

    @Override
    public Schedule generate(LocalDate start, LocalDate end, ReadablePeriod frequency) throws ScheduleException {
        ArrayList<SchedulePeriod> schedulePeriods = new ArrayList<SchedulePeriod>();
        LocalDate holdDate = start;
        int periodCount = 1;
        while (holdDate.isBefore(end)) {
            SchedulePeriod schedulePeriod;
            LocalDate nextDate = start.plus(this.multiplyPeriod(frequency, periodCount));
            LocalDate nextDate2 = start.plus(this.multiplyPeriod(frequency, periodCount + 1));
            if (nextDate2.isAfter(end)) {
                schedulePeriod = new SchedulePeriod(holdDate, end, holdDate, nextDate);
                schedulePeriods.add(schedulePeriod);
                holdDate = nextDate2;
            } else {
                schedulePeriod = new SchedulePeriod(holdDate, nextDate);
                schedulePeriods.add(schedulePeriod);
                holdDate = nextDate;
            }
            if (this.maxPeriods <= 0 || ++periodCount <= this.maxPeriods) continue;
            throw new ScheduleTooLongException(this.maxPeriods);
        }
        return new Schedule(schedulePeriods);
    }
}

