/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.schedule.impl;

import com.mbc.jfin.schedule.Schedule;
import com.mbc.jfin.schedule.ScheduleException;
import com.mbc.jfin.schedule.ScheduleService;
import com.mbc.jfin.schedule.StubType;
import com.mbc.jfin.schedule.impl.LongFirstStubScheduleGenerator;
import com.mbc.jfin.schedule.impl.LongLastStubScheduleGenerator;
import com.mbc.jfin.schedule.impl.NoStubScheduleGenerator;
import com.mbc.jfin.schedule.impl.ScheduleGenerator;
import com.mbc.jfin.schedule.impl.ShortFirstStubScheduleGenerator;
import com.mbc.jfin.schedule.impl.ShortLastStubScheduleGenerator;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePeriod;

public class DefaultScheduleServiceImpl
implements ScheduleService {
    private Map<StubType, ScheduleGenerator> generators = new HashMap<StubType, ScheduleGenerator>();

    public DefaultScheduleServiceImpl() {
        this(-1);
    }

    public DefaultScheduleServiceImpl(int maxPeriods) {
        this.generators.put(StubType.NONE, new NoStubScheduleGenerator(maxPeriods));
        this.generators.put(StubType.LONG_FIRST, new LongFirstStubScheduleGenerator(maxPeriods));
        this.generators.put(StubType.LONG_LAST, new LongLastStubScheduleGenerator(maxPeriods));
        this.generators.put(StubType.SHORT_FIRST, new ShortFirstStubScheduleGenerator(maxPeriods));
        this.generators.put(StubType.SHORT_LAST, new ShortLastStubScheduleGenerator(maxPeriods));
    }

    @Override
    public Schedule generateSchedule(LocalDate startDate, LocalDate endDate, ReadablePeriod frequency, StubType stubType) throws ScheduleException {
        ScheduleGenerator generator = this.generators.get((Object)stubType);
        if (generator == null) {
            throw new ScheduleException("Unsupported stub type: " + (Object)((Object)stubType));
        }
        return generator.generate(startDate, endDate, frequency);
    }
}

