/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount.impl.calculator;

import com.mbc.jfin.daycount.impl.DaycountCalculator;
import com.mbc.jfin.daycount.impl.InvalidReferencePeriodException;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.schedule.SchedulePeriod;
import com.mbc.jfin.util.DateUtils;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.Years;

public class ISMAActualActualDaycountCalculator
implements DaycountCalculator {
    @Override
    public double calculateDaycountFraction(SchedulePeriod schedulePeriod, HolidayCalendar calendar) {
        return this.calculateDaycountFraction(schedulePeriod);
    }

    private double calculateDaycountFraction(SchedulePeriod schedulePeriod) {
        LocalDate newRefEnd;
        LocalDate newRefStart;
        if (schedulePeriod.getStart().equals(schedulePeriod.getEnd())) {
            return 0.0;
        }
        LocalDate refPeriodStart = schedulePeriod.getReferenceStart() != null ? schedulePeriod.getReferenceStart() : schedulePeriod.getStart();
        LocalDate refPeriodEnd = schedulePeriod.getReferenceEnd() != null ? schedulePeriod.getReferenceEnd() : schedulePeriod.getEnd();
        LocalDate startCalendar = schedulePeriod.getStart();
        LocalDate endCalendar = schedulePeriod.getEnd();
        if (!refPeriodEnd.isAfter(refPeriodStart) || !refPeriodEnd.isAfter(startCalendar)) {
            throw new InvalidReferencePeriodException(schedulePeriod);
        }
        double monthsEstimate = (double)DateUtils.daysBetween(refPeriodStart, refPeriodEnd) * 0.03287671232876712;
        int months = (int)Math.round(monthsEstimate);
        if (months == 0) {
            refPeriodStart = startCalendar;
            refPeriodEnd = startCalendar.plus(Years.ONE);
            months = 12;
        }
        double period = (double)months / 12.0;
        if (endCalendar.isBefore(refPeriodEnd) || endCalendar.equals(refPeriodEnd)) {
            if (startCalendar.isAfter(refPeriodStart) || startCalendar.equals(refPeriodStart)) {
                long numerator = DateUtils.daysBetween(startCalendar, endCalendar);
                long denominator = DateUtils.daysBetween(refPeriodStart, refPeriodEnd);
                return period * (double)numerator / (double)denominator;
            }
            LocalDate previousRef = startCalendar;
            if (endCalendar.isAfter(refPeriodStart)) {
                return this.calculateDaycountFraction(new SchedulePeriod(startCalendar, refPeriodStart, previousRef, refPeriodStart)) + this.calculateDaycountFraction(new SchedulePeriod(refPeriodStart, endCalendar, refPeriodStart, refPeriodEnd));
            }
            return this.calculateDaycountFraction(new SchedulePeriod(startCalendar, endCalendar, previousRef, refPeriodStart));
        }
        if (!refPeriodStart.isBefore(startCalendar) && !refPeriodStart.equals(startCalendar)) {
            throw new InvalidReferencePeriodException(schedulePeriod);
        }
        double sum = this.calculateDaycountFraction(new SchedulePeriod(startCalendar, refPeriodEnd, refPeriodStart, refPeriodEnd));
        int i = 0;
        while (true) {
            newRefStart = refPeriodEnd.plus(Months.months(months * i));
            newRefEnd = refPeriodEnd.plus(Months.months(months * (i + 1)));
            if (endCalendar.isBefore(newRefEnd)) break;
            sum += period;
            ++i;
        }
        double secondSum = this.calculateDaycountFraction(new SchedulePeriod(newRefStart, endCalendar, newRefStart, newRefEnd));
        return sum += secondSum;
    }
}

