/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount.impl.calculator;

import com.mbc.jfin.daycount.impl.DaycountCalculator;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.schedule.SchedulePeriod;

public class EU30360DaycountCalculator
implements DaycountCalculator {
    @Override
    public double calculateDaycountFraction(SchedulePeriod period, HolidayCalendar calendar) {
        if (period.getStart().equals(period.getEnd())) {
            return 0.0;
        }
        int dayOfMonth1 = period.getStart().getDayOfMonth();
        int dayOfMonth2 = period.getEnd().getDayOfMonth();
        int month1 = period.getStart().getMonthOfYear();
        int month2 = period.getEnd().getMonthOfYear();
        int year1 = period.getStart().getYear();
        int year2 = period.getEnd().getYear();
        if (dayOfMonth1 == 31) {
            dayOfMonth1 = 30;
        }
        if (dayOfMonth2 == 31) {
            dayOfMonth2 = 30;
        }
        int numerator = 360 * (year2 - year1);
        numerator += 30 * (month2 - month1);
        return (double)(numerator += dayOfMonth2 - dayOfMonth1) / 360.0;
    }
}

