/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount.impl.calculator;

import com.mbc.jfin.daycount.impl.DaycountCalculator;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.schedule.SchedulePeriod;
import com.mbc.jfin.util.DateUtils;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.Years;

public class AFBActualActualDaycountCalculator
implements DaycountCalculator {
    @Override
    public double calculateDaycountFraction(SchedulePeriod period, HolidayCalendar calendar) {
        int daysBetween = DateUtils.daysBetween(period.getStart(), period.getEnd());
        if (daysBetween == 0) {
            return 0.0;
        }
        LocalDate newD2 = period.getEnd();
        LocalDate temp = period.getEnd();
        double sum = 0.0;
        while (temp.isAfter(period.getStart())) {
            temp = newD2;
            if ((temp = temp.minus(Years.ONE)).getDayOfMonth() == 28 && temp.getMonthOfYear() == 2 && DateUtils.isLeapYear(temp)) {
                temp = temp.plus(Days.ONE);
            }
            if (!temp.isAfter(period.getStart()) && !temp.equals(period.getStart())) continue;
            sum += 1.0;
            newD2 = temp;
        }
        double den = 365.0;
        if (DateUtils.isLeapYear(newD2)) {
            temp = newD2;
            if (newD2.isAfter(temp = new LocalDate(temp.getYear(), 2, 29)) && (period.getStart().isBefore(temp) || period.getStart().equals(temp))) {
                den += 1.0;
            }
        } else if (DateUtils.isLeapYear(period.getStart()) && newD2.isAfter(temp = new LocalDate(period.getStart().getYear(), 2, 29)) && (period.getStart().isBefore(temp) || period.getStart().equals(temp))) {
            den += 1.0;
        }
        return sum + (double)DateUtils.daysBetween(period.getStart(), newD2) / den;
    }
}

