/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount.impl;

import com.mbc.jfin.daycount.DaycountConvention;
import com.mbc.jfin.daycount.DaycountException;
import com.mbc.jfin.daycount.DaycountService;
import com.mbc.jfin.daycount.impl.DaycountCalculator;
import com.mbc.jfin.daycount.impl.DaycountNotImplementedException;
import com.mbc.jfin.daycount.impl.calculator.AFBActualActualDaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.Actual360DaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.Actual365FixedDaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.Actual366DaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.EU30360DaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.ISDAActualActualDaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.ISMAActualActualDaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.IT30360DaycountCalculator;
import com.mbc.jfin.daycount.impl.calculator.US30360DaycountCalculator;
import com.mbc.jfin.holiday.HolidayCalendar;
import com.mbc.jfin.schedule.SchedulePeriod;
import java.util.HashMap;
import java.util.Map;

public class DefaultDaycountServiceImpl
implements DaycountService {
    private Map<DaycountConvention, DaycountCalculator> calculators = new HashMap<DaycountConvention, DaycountCalculator>();

    public DefaultDaycountServiceImpl() {
        this.calculators.put(DaycountConvention.ACTUAL_360, new Actual360DaycountCalculator());
        this.calculators.put(DaycountConvention.ACTUAL_365_FIXED, new Actual365FixedDaycountCalculator());
        this.calculators.put(DaycountConvention.ACTUAL_366, new Actual366DaycountCalculator());
        this.calculators.put(DaycountConvention.AFB_ACTUAL_ACTUAL, new AFBActualActualDaycountCalculator());
        this.calculators.put(DaycountConvention.EU_30_360, new EU30360DaycountCalculator());
        this.calculators.put(DaycountConvention.ISDA_ACTUAL_ACTUAL, new ISDAActualActualDaycountCalculator());
        this.calculators.put(DaycountConvention.ISMA_ACTUAL_ACTUAL, new ISMAActualActualDaycountCalculator());
        this.calculators.put(DaycountConvention.IT_30_360, new IT30360DaycountCalculator());
        this.calculators.put(DaycountConvention.US_30_360, new US30360DaycountCalculator());
    }

    @Override
    public double calculateDaycountFraction(SchedulePeriod period, DaycountConvention convention, HolidayCalendar calendar) throws DaycountException {
        DaycountCalculator calculator = this.calculators.get((Object)convention);
        if (calculator == null) {
            throw new DaycountNotImplementedException(convention);
        }
        return calculator.calculateDaycountFraction(period, calendar);
    }
}

