/*
 * Decompiled with CFR 0.152.
 */
package com.mbc.jfin.daycount.impl;

import com.mbc.jfin.daycount.DaycountConvention;
import com.mbc.jfin.daycount.DaycountException;
import com.mbc.jfin.daycount.DaycountService;
import com.mbc.jfin.daycount.impl.DefaultDaycountServiceImpl;
import com.mbc.jfin.schedule.SchedulePeriod;
import junit.framework.TestCase;
import org.joda.time.LocalDate;

public class DaycountSanityTest
extends TestCase {
    private DaycountService service;
    private SchedulePeriod quarterlyPeriod;
    private SchedulePeriod semiPeriod;
    private SchedulePeriod annualPeriod;

    protected void setUp() throws Exception {
        this.service = new DefaultDaycountServiceImpl();
        this.quarterlyPeriod = new SchedulePeriod(new LocalDate(2011, 1, 1), new LocalDate(2011, 4, 1));
        this.semiPeriod = new SchedulePeriod(new LocalDate(2011, 1, 1), new LocalDate(2011, 7, 1));
        this.annualPeriod = new SchedulePeriod(new LocalDate(2011, 1, 1), new LocalDate(2012, 1, 1));
    }

    public void testACTUAL_360() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.ACTUAL_360, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.ACTUAL_360, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.ACTUAL_360, null), (double)0.04);
    }

    public void testACTUAL_365_FIXED() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.ACTUAL_365_FIXED, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.ACTUAL_365_FIXED, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.ACTUAL_365_FIXED, null), (double)0.04);
    }

    public void testACTUAL_366() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.ACTUAL_366, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.ACTUAL_366, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.ACTUAL_366, null), (double)0.04);
    }

    public void testAFB_ACTUAL_ACTUAL() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.AFB_ACTUAL_ACTUAL, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.AFB_ACTUAL_ACTUAL, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.AFB_ACTUAL_ACTUAL, null), (double)0.04);
    }

    public void testEU_30_360() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.EU_30_360, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.EU_30_360, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.EU_30_360, null), (double)0.04);
    }

    public void testISDA_ACTUAL_ACTUAL() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.ISDA_ACTUAL_ACTUAL, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.ISDA_ACTUAL_ACTUAL, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.ISDA_ACTUAL_ACTUAL, null), (double)0.04);
    }

    public void testISMA_ACTUAL_ACTUAL() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.ISMA_ACTUAL_ACTUAL, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.ISMA_ACTUAL_ACTUAL, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.ISMA_ACTUAL_ACTUAL, null), (double)0.04);
    }

    public void testIT_30_360() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.IT_30_360, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.IT_30_360, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.IT_30_360, null), (double)0.04);
    }

    public void testUS_30_360() throws DaycountException {
        DaycountSanityTest.assertEquals((double)0.25, (double)this.service.calculateDaycountFraction(this.quarterlyPeriod, DaycountConvention.US_30_360, null), (double)0.01);
        DaycountSanityTest.assertEquals((double)0.5, (double)this.service.calculateDaycountFraction(this.semiPeriod, DaycountConvention.US_30_360, null), (double)0.02);
        DaycountSanityTest.assertEquals((double)1.0, (double)this.service.calculateDaycountFraction(this.annualPeriod, DaycountConvention.US_30_360, null), (double)0.04);
    }
}

