/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.util;

import java.lang.ref.WeakReference;
import org.jquantlib.util.DefaultObservable;
import org.jquantlib.util.Observable;
import org.jquantlib.util.Observer;

public class WeakReferenceObservable
extends DefaultObservable {
    public WeakReferenceObservable(Observable observable) {
        super(observable);
    }

    @Override
    public void addObserver(Observer referent) {
        super.addObserver(new WeakReferenceObserver(referent));
    }

    @Override
    public void deleteObserver(Observer observer) {
        for (Observer weakObserver : this.getObservers()) {
            WeakReferenceObserver weakReference = (WeakReferenceObserver)weakObserver;
            Observer referent = (Observer)weakReference.get();
            if (referent != null && !referent.equals(observer)) continue;
            this.deleteWeakReference(weakReference);
        }
    }

    private void deleteWeakReference(WeakReferenceObserver observer) {
        super.deleteObserver(observer);
    }

    private class WeakReferenceObserver
    extends WeakReference<Observer>
    implements Observer {
        public WeakReferenceObserver(Observer referent) {
            super(referent);
        }

        @Override
        public void update() {
            Observer referent = (Observer)this.get();
            if (referent != null) {
                referent.update();
            } else {
                WeakReferenceObservable.this.deleteWeakReference(this);
            }
        }
    }
}

