/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Turkey
extends Calendar {
    public Turkey() {
        this.impl = new TurkeyImpl();
    }

    private final class TurkeyImpl
    extends Calendar.Impl {
        private TurkeyImpl() {
        }

        @Override
        public String name() {
            return "Turkey";
        }

        @Override
        public boolean isWeekend(Weekday w) {
            return w == Weekday.Saturday || w == Weekday.Sunday;
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            Month m = date.month();
            int y = date.year();
            if (this.isWeekend(w) || d == 1 && m == Month.January || d == 23 && m == Month.April || d == 19 && m == Month.May || d == 30 && m == Month.August || d == 29 && m == Month.October) {
                return false;
            }
            return !(y == 2004 ? m == Month.February && d <= 4 || m == Month.November && d >= 14 && d <= 16 : (y == 2005 ? m == Month.January && d >= 19 && d <= 21 || m == Month.November && d >= 2 && d <= 5 : (y == 2006 ? m == Month.January && d >= 9 && d <= 13 || m == Month.October && d >= 23 && d <= 25 || m == Month.December && d >= 30 : (y == 2007 ? m == Month.January && d <= 4 || m == Month.October && d >= 11 && d <= 14 || m == Month.December && d >= 19 && d <= 23 : y == 2008 && (m == Month.September && d >= 29 || m == Month.October && d <= 2 || m == Month.December && d >= 7 && d <= 11)))));
        }
    }
}

