/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class HongKong
extends Calendar {
    public HongKong() {
        this(Market.HKEx);
    }

    public HongKong(Market m) {
        switch (m) {
            case HKEx: {
                this.impl = new HkexImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class HkexImpl
    extends Calendar.WesternImpl {
        private HkexImpl() {
        }

        @Override
        public String name() {
            return "Hong Kong stock exchange";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            if (this.isWeekend(w) || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.January || d == 5 && m == Month.April || dd == em - 3 || dd == em || d == 1 && m == Month.May || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.July || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.October || d == 25 && m == Month.December || (d == 26 || (d == 27 || d == 28) && w == Weekday.Monday) && m == Month.December) {
                return false;
            }
            if (y == 2004 && ((d == 22 || d == 23 || d == 24) && m == Month.January || d == 26 && m == Month.May || d == 22 && m == Month.June || d == 29 && m == Month.September || d == 29 && m == Month.September)) {
                return false;
            }
            if (y == 2005 && ((d == 9 || d == 10 || d == 11) && m == Month.February || d == 16 && m == Month.May || d == 11 && m == Month.June || d == 19 && m == Month.September || d == 11 && m == Month.October)) {
                return false;
            }
            if (y == 2006 && (d >= 28 && d <= 31 && m == Month.January || d == 5 && m == Month.May || d == 31 && m == Month.May || d == 7 && m == Month.October || d == 30 && m == Month.October)) {
                return false;
            }
            if (y == 2007 && (d >= 17 && d <= 20 && m == Month.February || d == 24 && m == Month.May || d == 19 && m == Month.June || d == 26 && m == Month.September || d == 19 && m == Month.October)) {
                return false;
            }
            return y != 2008 || !(d >= 7 && d <= 9 && m == Month.February || d == 4 && m == Month.April || d == 12 && m == Month.May || d == 9 && m == Month.June || d == 15 && m == Month.September) && (d != 7 || m != Month.October);
        }
    }

    public static enum Market {
        HKEx;

    }
}

