/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class CzechRepublic
extends Calendar {
    public CzechRepublic() {
        this(Market.PSE);
    }

    public CzechRepublic(Market m) {
        switch (m) {
            case PSE: {
                this.impl = new PseImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class PseImpl
    extends Calendar.WesternImpl {
        private PseImpl() {
        }

        @Override
        public String name() {
            return "Prague stock exchange of CzechRepublic";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || d == 1 && m == Month.January || dd == em || d == 1 && m == Month.May || d == 8 && m == Month.May || d == 5 && m == Month.July || d == 6 && m == Month.July || d == 28 && m == Month.September || d == 28 && m == Month.October || d == 17 && m == Month.November || d == 24 && m == Month.December || d == 25 && m == Month.December || d == 26 && m == Month.December || d == 2 && m == Month.January && y == 2004) && (d != 31 || m != Month.December || y != 2004);
        }
    }

    public static enum Market {
        PSE;

    }
}

