/*
 * Decompiled with CFR 0.152.
 */
package org.jquantlib.time.calendars;

import org.jquantlib.lang.annotation.QualityAssurance;
import org.jquantlib.lang.exceptions.LibraryException;
import org.jquantlib.time.Calendar;
import org.jquantlib.time.Date;
import org.jquantlib.time.Month;
import org.jquantlib.time.Weekday;

@QualityAssurance(quality=QualityAssurance.Quality.Q3_DOCUMENTATION, version=QualityAssurance.Version.V097, reviewers={"Zahid Hussain"})
public class Canada
extends Calendar {
    public Canada() {
        this(Market.SETTLEMENT);
    }

    public Canada(Market market) {
        switch (market) {
            case SETTLEMENT: {
                this.impl = new SettlementImpl();
                break;
            }
            case TSX: {
                this.impl = new TsxImpl();
                break;
            }
            default: {
                throw new LibraryException("Unknown market");
            }
        }
    }

    private final class TsxImpl
    extends Calendar.WesternImpl {
        private TsxImpl() {
        }

        @Override
        public String name() {
            return "TSX";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.January || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.February && y >= 2008 || dd == em - 3 || dd == em || d > 17 && d <= 24 && w == Weekday.Monday && m == Month.May || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.July || d <= 7 && w == Weekday.Monday && m == Month.August || d <= 7 && w == Weekday.Monday && m == Month.September || d > 7 && d <= 14 && w == Weekday.Monday && m == Month.October || (d == 25 || d == 27 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December) && (d != 26 && (d != 28 || w != Weekday.Monday && w != Weekday.Tuesday) || m != Month.December);
        }
    }

    private final class SettlementImpl
    extends Calendar.WesternImpl {
        private SettlementImpl() {
        }

        @Override
        public String name() {
            return "Canada";
        }

        @Override
        public boolean isBusinessDay(Date date) {
            Weekday w = date.weekday();
            int d = date.dayOfMonth();
            int dd = date.dayOfYear();
            Month m = date.month();
            int y = date.year();
            int em = this.easterMonday(y);
            return !(this.isWeekend(w) || (d == 1 || d == 2 && w == Weekday.Monday) && m == Month.January || d >= 15 && d <= 21 && w == Weekday.Monday && m == Month.February && y >= 2008 || dd == em - 3 || dd == em || d > 17 && d <= 24 && w == Weekday.Monday && m == Month.May || (d == 1 || (d == 2 || d == 3) && w == Weekday.Monday) && m == Month.July || d <= 7 && w == Weekday.Monday && m == Month.August || d <= 7 && w == Weekday.Monday && m == Month.September || d > 7 && d <= 14 && w == Weekday.Monday && m == Month.October || (d == 11 || (d == 12 || d == 13) && w == Weekday.Monday) && m == Month.November || (d == 25 || d == 27 && (w == Weekday.Monday || w == Weekday.Tuesday)) && m == Month.December) && (d != 26 && (d != 28 || w != Weekday.Monday && w != Weekday.Tuesday) || m != Month.December);
        }
    }

    public static enum Market {
        SETTLEMENT,
        TSX;

    }
}

